% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen.R
\name{read_NSdata}
\alias{read_NSdata}
\title{Read NS data}
\usage{
read_NSdata(path, tsn, obs, ff, rain, topo, lr, length)
}
\arguments{
\item{path}{string. A string with the path of the CSV files.}

\item{tsn}{file. A CSV file with nine variables YearValue (integer),
HydroID (integer), Atm (float), Min (float), Man (float), Fix (float),
Soil (float), Sd (float) and Ps (float).}

\item{obs}{file. A CSV file with three variables YearValue (integer),
HydroID (integer) and YearlyMass (float).}

\item{ff}{file. A CSV file with three variables YearValue (integer),
HydroID (integer) and ForestFraction (float).}

\item{rain}{file. A CSV file with three variables YearValue (integer),
HydroID (integer) and Rain (float).}

\item{topo}{file. A CSV file with two variables HydroID (integer) and
Next_HydroID (integer).}

\item{lr}{file. A CSV file with three variables HydroID (integer),
AvgDepth (float) and ResTime (float).}

\item{length}{file. A CSV file with two variables HydroID (integer) and
LengthKm (float).}
}
\value{
One object, a list with two data frame. First position of the list
contains the catch data and the second one the annual data.
}
\description{
Function to read the data and return the data frame for GREEN
execution.
}
\examples{
\donttest{
path <- "https://raw.githubusercontent.com/calfarog/GREENeR_data/main/data/csv/"
ns_data <- read_NSdata(path, "TS_nutrients.csv", "Obs_monitoring.csv",
"ForestFr.csv", "Precipitation.csv", "Topology.csv", "LakeProperties.csv",
"Length.csv")
}

}
