% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{RepoBuildParam-class}
\alias{RepoBuildParam-class}
\alias{RepoBuildParam}
\title{RepoBuildParam}
\usage{
RepoBuildParam(basedir, repo_name = "current",
  temp_repo = file.path(basedir, repo_name, "tmprepo"),
  temp_checkout = file.path(basedir, "tmpcheckout"),
  errlog = file.path(basedir, repo_name, paste0("GRAN-errors-", repo_name,
  "-", Sys.Date(), ".log")), logfile = file.path(basedir, repo_name,
  paste0("GRAN-log-", repo_name, "-", Sys.Date(), ".log")),
  check_note_ok = TRUE, check_warn_ok = TRUE,
  tempLibLoc = file.path(basedir, repo_name, "LibLoc"),
  extra_fun = function(...) NULL, destination = basedir, auth = "",
  dest_url = makeFileURL(normalizePath2(destination)),
  shell_init = character(), loginnerfun = writeGRANLog,
  install_test = TRUE, check_test = TRUE, use_cran_granbase = TRUE,
  archive_timing = 2, archive_retries = 2, build_timeout = 10 * 60,
  check_timeout = 15 * 60, email_notifications = FALSE,
  email_opts = list(smtp_server = "localhost", smtp_port = 25, sender_email =
  paste0("gran", repo_name, "@localhost"), unsubscribers = NULL))
}
\arguments{
\item{basedir}{The base directory. By default the temporary repository,
temporary install library, and package staging area will be located in
<basedir>/<subrepoName>/, while the  temporary source checkout will be in t
he basedir itself.}

\item{repo_name}{The name of the repository, e.g. stable or devel}

\item{temp_repo}{Location to create the temporary repository}

\item{temp_checkout}{Location to create temporary checkouts/copies of package
source code}

\item{errlog}{The file to append error output to during the building and
testing processes}

\item{logfile}{The file to append summary log information to during building
and testing}

\item{check_note_ok}{logical. Whether packages that raise notes during
R CMD check should be considered to have passed}

\item{check_warn_ok}{logical. Whether packages that raise warnings during
R CMD check should be considered to have passed}

\item{tempLibLoc}{Location to create the temporary installed package library
for use during the testing process}

\item{extra_fun}{currently ignored}

\item{destination}{Base location (not including repository name) of the
final repository to be built}

\item{auth}{character. Authentication information required to add packages
to the manifest.}

\item{dest_url}{The base URL the destination directory corresponds to. The
subrepository name will be appended to this to generate the URL used when
installing from the repository.}

\item{shell_init}{An optional shell script to source before invoking system
commands, e.g. a bashrc file. Ignored if "" or not specified.}

\item{loginnerfun}{The function to use to write log messages during the repository
build process. It will be passed pkg, ..., errfile, logfile, and pkglog based on
the other arguments to this function. Defaults to writeGRANLog
specified as the full and error log locations, respectively.}

\item{install_test}{logical. Should the install test be performed? Required
to build packages with vignettes, and for the check test}

\item{check_test}{logical. Should R CMD check be run on the packages as a
cohort. Requires install test.}

\item{use_cran_granbase}{logical. Currently ignored.}

\item{archive_timing}{numeric. Number of seconds to wait between attempts to pull a package from the CRAN archive}

\item{archive_retries}{numeric. Number of times to retry pulling a package from the CRAN archive.}

\item{build_timeout}{numeric. Number of seconds before timeout during
the build step for a single package. Defaults to 10 minutes.}

\item{check_timeout}{numeric. Number of seconds before timeout during
the check step for a single package. Defaults to 15 minutes.}

\item{email_notifications}{logical. Should email notifications be sent
regarding packages that fail to build on GRAN? Defaults to FALSE}

\item{email_opts}{List. Email options for sending emails regarding packages
that fail to build on GRAN. The list contains 4 elements: \code{smtp_server}:
the SMTP server - defaults to "localhost", \code{smtp_port}: SMTP port
number - defaults to 25, \code{sender_email}: Whom should the emails
be sent as? Defaults to "gran<repo_name>@localhost", \code{unsubscribers}:
Vector of Perl-style regexes for unsubscribers - defaults to NULL.}
}
\description{
Parameters for building a GRAN repository. Most behavior during the
GRAN building process is specified via this object/constructor.
}
