% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecchia_specify.R
\name{vecchia_specify}
\alias{vecchia_specify}
\title{specify a general vecchia approximation}
\usage{
vecchia_specify(locs, m = -1, ordering, cond.yz, locs.pred,
  ordering.pred, pred.cond, conditioning, mra.options = NULL,
  verbose = FALSE)
}
\arguments{
\item{locs}{nxd matrix of observed locs}

\item{m}{Number of nearby points to condition on}

\item{ordering}{options are 'coord' or 'maxmin'}

\item{cond.yz}{options are 'y', 'z', 'SGV', 'SGVT', 'RVP', 'LK', and 'zy'}

\item{locs.pred}{nxd matrix of locations at which to make predictions}

\item{ordering.pred}{options are 'obspred' or 'general'}

\item{pred.cond}{prediction conditioning, options are 'general' or 'independent'}

\item{conditioning}{conditioning on 'NN' (nearest neighbor) or 'firstm' (fixed set for low rank)
or 'mra'}

\item{mra.options}{Settings for number of levels and neighbors per level}

\item{verbose}{Provide more detail when using MRA calculations.  Default is false.}
}
\value{
An object that specifies the vecchia approximation for later use in likelihood
evaluation or prediction.
}
\description{
specify the vecchia approximation for later use in likelihood evaluation or prediction.
This function does not depend on parameter values, and only has to be run once before
repeated likelihood evaluations.
}
\examples{
locs=matrix(1:5,ncol=1); vecchia_specify(locs,m=2)
}
