% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_clus_gpx.R
\name{exp_clus_gpx}
\alias{exp_clus_gpx}
\title{Export cluster .gpx file}
\usage{
exp_clus_gpx(AID, cn = "all", locs, cs, centroid_calc = "mean", dir = NULL)
}
\arguments{
\item{AID}{Desired AID from sequential cluster output}

\item{cn}{Numeric vector of desired cluster numbers to include in .gpx output, default is "all"}

\item{locs}{Location dataframe output from GPSeq_clus()}

\item{cs}{Cluster summary output from GPSeq_clus()}

\item{centroid_calc}{'mean' (default) or 'median' centroid plot}

\item{dir}{File path to save output}
}
\value{
.gpx file
}
\description{
Uses results from 'GPSeq_clus" to export .gpx file from specified AID and vector of desired cluster numbers
for navigation during field site investigations.
}
\examples{
\donttest{
exp_clus_gpx(AID = "ML1605M", cn = 4,
             locs = GPSeq_clus(dat = ML_ex_dat[1:50,], search_radius_m = 200, window_days = 6,
                    clus_min_locs = 3, show_plots = c(FALSE, "mean"))[[1]],
             cs = GPSeq_clus(dat = ML_ex_dat[1:50,], search_radius_m = 200, window_days = 6,
                  clus_min_locs = 3, show_plots = c(FALSE, "mean"))[[2]],
             dir= tempdir()
)
}

}
