% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPPFourier.R
\name{WindowGPPFourier}
\alias{WindowGPPFourier}
\title{Calculate GPP from O2 time series in consecutive time-windows of prescribed
length}
\usage{
WindowGPPFourier(x, dt = NULL, units = c("days", "hours", "mins"),
  Width = 14, Nblocks = floor(unclass(difftime(range(ts[, 1])[2], range(ts[,
  1])[1], units = "days"))[1]/Width), fDL = NULL, phi, lambda,
  filtWidth = 16, ...)
}
\arguments{
\item{x}{Vector or dataframe containing consecutive O2 concentrations, sampled at regular intervals (time step = dt). In case of irregular time intervals, consider \code{\link{resample}}.
When x is a data frame, time (POSIXt) must be in first column and O2 in second column; when x is a vector, dt must be provided.}

\item{dt}{Sampling time step. Either a difftime object or a numerical value. When \code{dt} is given as a numerical value, 
\code{units} have to be provided. Can be omitted when \code{x} is a data frame, then \code{dt} is calculated from the 
time spacing between the first two samples.}

\item{units}{Unit of sampling time step}

\item{Width}{Width [days] of the time-windows for which GPP is calculated}

\item{Nblocks}{Number of consecutive subsections on which to calculate GPP. By default the number of windows of Width fitting into the range of x[,1]
Default the largest number of blocks ow width=Width that}

\item{fDL}{Optional. Relative fraction of daylight. When \code{x} is a data frame, fDL is calculated with \code{\link{fDLfun}}}

\item{phi}{Latitude of location where O2 series was recorded. Used to
calculate relative fraction of light hours during the day, during which
production takes place}

\item{lambda}{Longitude of location where O2 series was recorded}

\item{filtWidth}{[hours] Lenght of moving average filter to filter O2
series. See GPPFourierPreprocess()}

\item{...}{Other parameters to be passed to \code{GPPFourier()}}
}
\value{
Average gross primary production in units of oxgen as in \code{x}
per day.
}
\description{
Calculate GPP from O2 time series in consecutive time-windows of prescribed
length.
}
\details{
no details
}
\references{
Cox T.J.S. et al. (2015) 'Estimating primary production from oxygen time series: a novel approach in the frequency domain', Limnology And Oceanography:Methods 13, 529-552. DOI: 10.1002/lom3.10046
}
\seealso{
\code{\link{GPPFourierPreprocess}}, \code{\link{GPPFourier}}, \code{\link{GPPFourier_t}}, \code{\link{WindowGPPFourier.gts}}, \code{\link{SunRiseSet}}
}
\author{
Tom Cox <tom.cox@uantwerp.be>
}
\keyword{utilities}
