% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degreeDistCC.R
\name{degreeDistCC}
\alias{degreeDistCC}
\title{Degree distribution of the GO cellular component (CC) terms on a GO level}
\usage{
degreeDistCC(level)
}
\arguments{
\item{level}{A numeric value for the GO level}
}
\value{
A plot showing the degree distribution
}
\description{
For a directed graph, the in-degree nodes are the nodes which have edges coming into them
             and the out-degree nodes are those which have edges going out of them. The degreeDistCC
             function shows the distribution of these degrees over a particular GO level. A bar plot is obtain
             which shows how many nodes in the GO level have a certain degree k.
}
\examples{
# Degree distribution of GO terms on level 8
degreeDistCC(level = 8)

# Degree distribution of GO terms on level 6
degreeDistCC(level = 6)

}
