% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inv.rho.transform.R, R/rho.transform.R
\name{inv.rho.transform}
\alias{inv.rho.transform}
\alias{rho.transform}
\title{Transformation of the correlation to real line and its inverse}
\usage{
inv.rho.transform(a, d)

rho.transform(rho, d)
}
\arguments{
\item{a}{A real number.}

\item{d}{The dimension of the space.}

\item{rho}{A correlation coefficient between \code{-1/(d-1)} and \code{1}.}
}
\value{
\code{inv.rho.transform} returns a vector of the inversely
  transformed values with the same length as \code{a}.

\code{rho.transform} returns a vector of the transformed values with
  the same length as \code{rho} or \code{a}.
}
\description{
A transformation of the correlation coefficient into the real line and the
corresponding inverse. The transform is a translation and scaling of
\eqn{\rho}{rho} from the interval \eqn{(-1/(d-1), 1)}{(-1/(d-1), 1)} to
\eqn{(0, 1)}{(0, 1)} followed by a logit transformation to the whole real
line.
}
\examples{
d <- 4
rho <- runif(100, -1/(d-1), 1)
a <- GMCM:::rho.transform(rho, d)
rho - GMCM:::inv.rho.transform(a, d)
}
\seealso{
Used in \code{\link{tt}} and \code{\link{inv.tt}}.
}
\author{
Anders Ellern Bilgrau <anders.ellern.bilgrau@gmail.com>
}
\keyword{internal}
