# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

colSdsArma <- function(X, norm_type = 0L) {
    .Call('_GMCM_colSdsArma', PACKAGE = 'GMCM', X, norm_type)
}

rowSdsArma <- function(X, norm_type = 0L) {
    .Call('_GMCM_rowSdsArma', PACKAGE = 'GMCM', X, norm_type)
}

#' Multivariate Gaussian density and simulation
#'
#' Fast simulation from and evaluation of multivariate Gaussian probability
#' densities.
#'
#' \code{dmvnormal} functions similarly to \code{dmvnorm} from the
#' \code{mvtnorm}-package and likewise for \code{rmvnormal} and
#' \code{rmvnorm}.
#'
#' @aliases dmvnormal rmvnormal
#' @param x A \code{p} times \code{k} matrix of quantiles. Each rows
#'   correspond to a realization from the density and each column corresponds
#'   to a dimension.
#' @param mu The mean vector of dimension \code{k}.
#' @param sigma The variance-covariance matrix of dimension \code{k} times
#'   \code{k}.
#' @return \code{dmvnormal} returns a \eqn{1} by \eqn{p} matrix of the
#'   probability densities corresponding to each row of \code{x}.
#' \code{sigma}. Each row corresponds to an observation.
#' @author Anders Ellern Bilgrau
#' @seealso \code{dmvnorm} and \code{rmvnorm} in the \code{mvtnorm}-package.
#' @examples
#' dmvnormal(x = matrix(rnorm(300), 100, 3),
#'           mu = 1:3,
#'           sigma = diag(3))
#' @export
dmvnormal <- function(x, mu, sigma) {
    .Call('_GMCM_dmvnormal', PACKAGE = 'GMCM', x, mu, sigma)
}

#' @rdname dmvnormal
#' @param n The number of observations to be simulated.
#' @return \code{rmvnormal} returns a \code{p} by \code{k} matrix of
#'   observations from a multivariate normal distribution with the given mean
#'   \code{mu} and covariance
#' @examples
#' rmvnormal(n = 10, mu = 1:4, sigma = diag(4))
#' @export
rmvnormal <- function(n, mu, sigma) {
    .Call('_GMCM_rmvnormal', PACKAGE = 'GMCM', n, mu, sigma)
}

dgmm_loglik <- function(mus, sigmas, pie, z, marginal_loglik) {
    .Call('_GMCM_dgmm_loglik', PACKAGE = 'GMCM', mus, sigmas, pie, z, marginal_loglik)
}

dgmm_loglik_marginal <- function(mus, sigmas, pie, z, marginal_loglik) {
    .Call('_GMCM_dgmm_loglik_marginal', PACKAGE = 'GMCM', mus, sigmas, pie, z, marginal_loglik)
}

approx_pnorm <- function(z, mu, sd) {
    .Call('_GMCM_approx_pnorm', PACKAGE = 'GMCM', z, mu, sd)
}

pgmm_marginal <- function(z, mus, sigmas, pie) {
    .Call('_GMCM_pgmm_marginal', PACKAGE = 'GMCM', z, mus, sigmas, pie)
}

EStepRcpp <- function(z, mus, sigmas, pie) {
    .Call('_GMCM_EStepRcpp', PACKAGE = 'GMCM', z, mus, sigmas, pie)
}

