% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_utils.R
\name{update_formula_and_data}
\alias{update_formula_and_data}
\title{Update data and formula for fitting cglmm model}
\usage{
update_formula_and_data(
  data,
  formula,
  family = "gaussian",
  quietly = TRUE,
  dispformula = ~1,
  ziformula = ~0
)
}
\arguments{
\item{data}{input data for fitting cglmm model.}

\item{formula}{model formula, specified by user including \code{amp_acro()}.}

\item{family}{the model family.}

\item{quietly}{controls whether messages from amp_acro are displayed.
TRUE by default}

\item{dispformula}{The formula specifying the dispersion model}

\item{ziformula}{The formula specifying the zero-inflation model}
}
\value{
Returns a \code{list}.
}
\description{
Update data and formula for fitting cglmm model
}
\examples{
# Use vitamind data but add a "patient" identifier used as a random effect
vitamind2 <- vitamind
vitamind2$patient <- sample(
  LETTERS[1:5],
  size = nrow(vitamind2), replace = TRUE
)

# Use update_formula_and_data() to perform wrangling steps of cglmm()
# without yet fitting the model
data_and_formula <- update_formula_and_data(
  data = vitamind2,
  formula = vit_d ~ X + amp_acro(time,
    group = "X",
    period = 12
  )
)

# print formula from above
data_and_formula$newformula

# fit model while adding random effect to cosinor model formula.
mod <- fit_model_and_process(
  obj = data_and_formula,
  formula = update.formula(
    data_and_formula$newformula, . ~ . + (1 | patient)
  )
)

mod
mod$fit # printing the `glmmTMB` model within shows Std.Dev. of random effect
}
