% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_cosinor.R
\name{test_cosinor_components}
\alias{test_cosinor_components}
\title{Test for differences in a cosinor model between components.}
\usage{
test_cosinor_components(
  x,
  x_str = NULL,
  param = "amp",
  comparison_A = 1,
  comparison_B = 2,
  level_index = 0,
  ci_level = 0.95
)
}
\arguments{
\item{x}{An \code{cglmm} object.}

\item{x_str}{A \code{character}. The name of the grouping variable within
which differences in the selected cosinor characteristic (amplitude or
acrophase) will be tested. If there is no grouping variable in the model,
then this can be left as NULL (default).}

\item{param}{A \code{character}. Either \code{"amp"} or \code{"acr"} for
testing differences in amplitude or acrophase, respectively.}

\item{comparison_A}{An \code{integer}. Refers to the component number that is
to act as the reference group.
for the comparison.}

\item{comparison_B}{An \code{integer}. Refers to the component number that is
to act as the comparator group}

\item{level_index}{An \code{integer}. If
\code{comparison_type = "components"}, \code{level_index} indicates which
level of the grouping variable is being used for the comparison between
components.}

\item{ci_level}{The level for calculated confidence intervals. Defaults to
\code{0.95}.}
}
\value{
Returns a \code{test_cosinor} object.
}
\description{
Given a time variable and optional covariates, generate inference a cosinor
fit. For the covariate named (or vector of covariates), this function
performs a Wald test comparing the group with covariates equal to 1 to the
group with covariates equal to 0. This may not be the desired result for
continuous covariates.
}
\examples{
data_2_component <- simulate_cosinor(
  n = 10000,
  mesor = 5,
  amp = c(2, 5),
  acro = c(0, pi),
  beta.mesor = 4,
  beta.amp = c(3, 4),
  beta.acro = c(0, pi / 2),
  family = "gaussian",
  n_components = 2,
  period = c(10, 12),
  beta.group = TRUE
)
mod_2_component <- cglmm(
  Y ~ group + amp_acro(times,
    n_components = 2, group = "group",
    period = c(10, 12)
  ),
  data = data_2_component
)
test_cosinor_components(mod_2_component, param = "amp", x_str = "group")
}
