% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.cglmm}
\alias{summary.cglmm}
\title{Summarize a cosinor model
Given a time variable and optional covariates, generate inference a cosinor
fit. Gives estimates, confidence intervals, and tests for the raw parameters,
and for the mean, amplitude, and acrophase parameters. If the model includes
covariates, the function returns the estimates of the mean, amplitude, and
acrophase for the group with covariates equal to 1 and equal to 0. This may
not be the desired result for continuous covariates.}
\usage{
\method{summary}{cglmm}(object, ci_level = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{cglmm}}

\item{ci_level}{The level for calculated confidence intervals. Defaults to
0.95.}

\item{...}{Currently unused}
}
\value{
Returns a summary of the \code{cglmm} model as
a \code{cglmmSummary} object.
}
\description{
Summarize a cosinor model
Given a time variable and optional covariates, generate inference a cosinor
fit. Gives estimates, confidence intervals, and tests for the raw parameters,
and for the mean, amplitude, and acrophase parameters. If the model includes
covariates, the function returns the estimates of the mean, amplitude, and
acrophase for the group with covariates equal to 1 and equal to 0. This may
not be the desired result for continuous covariates.
}
\examples{


fit <- cglmm(vit_d ~ X + amp_acro(time,
  group = "X",
  n_components = 1,
  period = 12
), data = vitamind)
summary(fit)

}
