% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cglmm.R
\name{cglmm}
\alias{cglmm}
\title{Fit cosinor model with \code{{glmmTMB}}}
\usage{
cglmm(
  formula,
  data,
  family = stats::gaussian(),
  quietly = TRUE,
  dispformula = ~1,
  ziformula = ~0,
  ...
)
}
\arguments{
\item{formula}{A \code{formula} specifying the cosinor model to be fit.
The cosinor portion of the formula is controlled by including
\code{amp_acro()} on the right hand side of the formula.
See \code{\link{amp_acro}} for more details.}

\item{data}{A \code{data.frame} containing the variables used in the model.}

\item{family}{A \code{family} function or a character string naming a family
function. See \code{?family} and \code{?glmmTMB::family_glmmTMB} for options.}

\item{quietly}{A \code{logical}. If \code{TRUE}, shows warning messages when
wrangling data and fitting model. Defaults to \code{TRUE}.}

\item{dispformula}{A one-sided (i.e., no response variable) \code{formula}
for dispersion combining fixed and random effects, including cosinor
components using \code{amp_acro()}. Defaults to \code{~1}.}

\item{ziformula}{A one-sided (i.e., no response variable) \code{formula}
for zero-inflation combining fixed and random effects, including cosinor
components using \code{amp_acro()}. Defaults to \code{~0}.}

\item{...}{Optional additional arguments passed to \code{glmmTMB::glmmTMB()}.}
}
\value{
Returns a fitted cosinor model as a \code{cglmm} object.
}
\description{
Given an outcome and time variable, fit the cosinor model with optional
covariate effects.
}
\examples{
# Single component cosinor model
cglmm(
  vit_d ~ amp_acro(time_col = time, group = "X", period = 12),
  data = vitamind
)

# 2-component cosinor model with simulated data
sim_data <- simulate_cosinor(
  n = 500,
  mesor = 5,
  amp = c(2, 1),
  acro = c(1, 1.5),
  beta.mesor = 2,
  beta.amp = c(2, 1),
  beta.acro = c(1, 1.5),
  family = "gaussian",
  period = c(12, 6),
  n_components = 2,
  beta.group = TRUE,
)

cglmm(
  Y ~ group + amp_acro(times,
    n_components = 2,
    group = "group",
    period = c(12, 6)
  ),
  data = sim_data,
  family = gaussian
)
}
\references{
Tong, YL. Parameter Estimation in Studying Circadian
Rhythms, Biometrics (1976). 32(1):85--94.
}
