% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_traits_raw.R
\name{GIFT_traits_raw}
\alias{GIFT_traits_raw}
\title{Raw trait values}
\usage{
GIFT_traits_raw(
  trait_IDs = "",
  derived = TRUE,
  bias_ref = TRUE,
  bias_deriv = TRUE,
  api = "https://gift.uni-goettingen.de/api/extended/",
  GIFT_version = "latest"
)
}
\arguments{
\item{trait_IDs}{a character string indicating which traits you want to
retrieve. Traits must belong to the available list of traits. See
\code{\link[=GIFT_traits_meta]{GIFT_traits_meta()}}.}

\item{derived}{include logically derived traits.}

\item{bias_ref}{When \code{FALSE}, exclude entries that are only based on a
resource that potentially introduces a bias (e.g. a resource only including
trees).}

\item{bias_deriv}{When \code{FALSE}, exclude entries that are only based on a
derivation that potentially introduces a bias (e.g. all phanerophytes being
woody but some life forms being ambiguous).}

\item{api}{character string defining from which API the data will be
retrieved.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}
}
\value{
A data.frame with 28 columns.
}
\description{
Retrieve non-aggregated trait values at the level of the bibliographic
references and un-standardized species names in GIFT.
}
\details{
Here is the detail of each column:

\emph{trait_derived_ID} - Identification number of the trait record in the
database\cr
\emph{ref_ID} - Identification number of the reference\cr
\emph{orig_ID} - Identification number of the species, as it came in the
source\cr
\emph{trait_ID} - Identification number of the trait\cr
\emph{trait_value} - Value of the trait (coded as character, even for
continuous trait)\cr
\emph{derived} - Is the trait value derived from another information (e.g.
phanerophytes are woody)\cr
\emph{bias_deriv} - Is the derivation potentially introducing a bias\cr
\emph{bias_ref} - Is the resource potentially introducing a bias\cr
\emph{name_ID} - Identification number of the species before being
resolved\cr
\emph{cf_genus} - Whether the genus name is uncertain\cr
\emph{genus} - Genus of the species\cr
\emph{cf_species} - Whether the species' epithet is uncertain\cr
\emph{aff_species} - Species' epithet uncertain\cr
\emph{species_epithet} - Epithet of the species\cr
\emph{subtaxon} - Sub-taxon name\cr
\emph{author} - Author who described the species\cr
\emph{matched} - Was the species name matched in the taxonomic backbone\cr
\emph{epithetscore} - Matching score for the epithet\cr
\emph{overallscore} - Overall matching score\cr
\emph{resolved} - Was the species name resolved in the taxonomic
backbone\cr
\emph{service} - Taxonomic backbone used for taxonomic harmonization\cr
\emph{work_ID} - Identification number of the taxonomically harmonized
species\cr
\emph{genus_ID} - Identification number of the taxonomically harmonized
genus\cr
\emph{work_genus} - Genus name (after taxonomic harmonization)\cr
\emph{work_species} - Species name (after taxonomic harmonization)\cr
\emph{work_author} - Name of the author who described the species\cr
\emph{geo_entity} _ref - Name of the region of the reference\cr
\emph{ref_long} - Full reference to cite
}
\examples{
\donttest{
succulence <- GIFT_traits_raw(trait_IDs = c("4.10.1"))
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_traits_meta]{GIFT_traits_meta()}} and \code{\link[=GIFT_traits]{GIFT_traits()}}
}
