% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_covariates.R
\name{cov_varying}
\alias{cov_varying}
\title{Create Spatially or Temporally Varying Effects for INLA}
\usage{
cov_varying(
  covariates,
  unit,
  pattern = NULL,
  name = NULL,
  model = "iid",
  constr = FALSE,
  add = FALSE
)
}
\arguments{
\item{covariates}{A character vector or a list of character vectors of covariate names.
Typically output from \code{\link{cov_multi}}, \code{\link{cov_uni}}, or \code{\link{extract_names}}.}

\item{unit}{Character string specifying the unit of variation (e.g., \code{"spat_id"}, \code{"year"}).}

\item{pattern}{A character vector specifying the prefix pattern(s) to match (e.g., "tmin" matches "tmin", "tmin.l1", etc.)
for transformation.}

\item{name}{Character vector of exact variable names to be transformed.}

\item{model}{Character string specifying the INLA model for the varying effect. Currently, only \code{"iid"} is supported.}

\item{constr}{Logical. If TRUE it will impose a sum-to-zero constraint to the random effect.
Default is FALSE.}

\item{add}{Logical; if \code{TRUE}, appends the transformed covariates to the original ones. Default is \code{FALSE}.}
}
\value{
A list of character vectors, each including covariates with varying effects.
The output is suitable as input for \code{\link{write_inla_formulas}}.
}
\description{
This function transforms covariates identified by \code{pattern} or  \code{name} into
varying effect terms of the form:\code{f(unit, covariate, model = 'iid')},
which allows covariates to have varying slopes across spatial or temporal units.
The output can be used directly in the \code{covariates} argument of \code{\link{write_inla_formulas}}.
}
\details{
\itemize{
\item Use \code{pattern} or \code{name} (or both) to specify which covariates to transform.
\item The resulting terms use INLA’s \code{f()} syntax: \code{f(unit, covariate, model = "iid")}.
\item Currently only supports \code{"iid"} models for varying effects.
}
}
\examples{
data <- data.frame(tmin.l1 = rnorm(10), pdsi.l1 = rnorm(10))

covs <- extract_names(data, pattern = c("tmin", "pdsi"))
covlist <- cov_multi(covs, pattern = c("tmin", "pdsi"))

# Apply varying effect to tmin
cov_varying(covlist, pattern = "tmin", unit = "spat_id")

# Keep original and add varying effect terms
cov_varying(covlist, pattern = "tmin", unit = "spat_id", add = TRUE)
}
