% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_correlation.R
\name{plot_correlation}
\alias{plot_correlation}
\title{Correlation plot}
\usage{
plot_correlation(
  data,
  var,
  var_label = NULL,
  method = "pearson",
  plot_type = c("circle", "number"),
  scale = 1,
  title = NULL,
  palette = "IDE1",
  print = FALSE
)
}
\arguments{
\item{data}{Data frame containing equally spaced (daily, weekly, monthly)
covariate or disease case observations for one or multiple locations.}

\item{var}{Character vector containing variables in \code{data} to include in the
correlation matrix.}

\item{var_label}{Optional character vector of the same length as \code{var}
containing custom names for the variables.}

\item{method}{Correlation computation method. Options include "pearson"
(default), "spearman" or "kendall".}

\item{plot_type}{Character vector of length 2 indicating the type of plot to
use in the lower triangular and diagonal (1st element) and the upper triangular
(2nd element). Options include "circle", "number" and "raster".}

\item{scale}{Circle and number size multiplier, e.g. 1.1 increases
the size a 10\% while 0.9 decreases it a 10\%.}

\item{title}{Optional title of the plot.}

\item{palette}{GHR, RColorBrewer or colorspace palette. Use "-" before the palette
name (e.g., "-Reds") to reverse it.}

\item{print}{Logical. If TRUE, print the correlation matrix.}
}
\value{
A plot of the correlation matrix.
}
\description{
Plots a correlation matrix of a series of variables.
}
\examples{
# Load data
data("dengue_MS")

# Pearson correlation plot
plot_correlation(dengue_MS, 
                 method = "pearson",
                 var = c("dengue_cases","pop_density", 
                         "tmax", "tmin", "pdsi", "urban",
                         "water_network", "water_shortage"),  
                 var_label = c("dengue cases","pop. density", 
                               "max temp", "min temp", "drought index", "urbanization",
                               "water network", "water shortage"),
                 title = "Correlation matrix") 

# Print spearman correlation plot of type 'raster' and 'number' 
# with another palette 
plot_correlation(dengue_MS,
                 method = "spearman",
                 var = c("dengue_cases","pop_density", 
                         "tmax", "tmin", "pdsi", "urban",
                         "water_network", "water_shortage"),  
                 var_label = c("dengue cases","pop. density", 
                               "max temp", "min temp", "drought index", "urbanization",
                               "water network", "water shortage"),
                 plot_type = c("raster", "number"),
                 palette = "-Blue-Red 3") 

}
