% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desparsify.R
\name{desparsify}
\alias{desparsify}
\title{De-Sparsified Graphical Lasso Estimator}
\usage{
desparsify(object, ...)
}
\arguments{
\item{object}{An object of class \code{ggmncv}.}

\item{...}{Currently ignored.}
}
\value{
The de-sparsified estimates, including

\itemize{

\item \code{Theta}:  De-sparsified precision matrix

\item \code{P}:  De-sparsified partial correlation matrix

}
}
\description{
\loadmathjax
Compute the de-sparsified (sometimes called "de-biased") glasso estimator with
the approach described in Equation 7 of \insertCite{jankova2015confidence;textual}{GGMncv}.
The basic idea is to \emph{undo} \mjseqn{L_1}-regularization, in order
to compute \emph{p}-values and confidence intervals
(i.e., to make statistical inference).
}
\details{
According to \insertCite{jankova2015confidence;textual}{GGMncv}, the de-sparisifed estimator,
\mjseqn{\hat{\mathrm{\bf T}}}, is defined as

\mjseqn{\hat{\mathrm{\bf T}} = 2\hat{\boldsymbol{\Theta}} - \hat{\boldsymbol{\Theta}}\hat{\mathrm{\bf R}}\hat{\boldsymbol{\Theta}},}

where \mjseqn{\hat{\boldsymbol{\Theta}}} denotes the graphical lasso estimator of the precision matrix
and \mjseqn{\hat{\mathrm{\bf R}}} is the sample correlation matrix. Further details can be
found in Section 2 ("Main Results") of \insertCite{jankova2015confidence;textual}{GGMncv}.

This approach is built upon earlier work on the de-sparsified lasso estimator
\insertCite{javanmard2014confidence,van2014asymptotically,zhang2014confidence}{GGMncv}
}
\note{
This assumes (reasonably) Gaussian data, and should not to be expected
to work for, say, polychoric correlations. Further, all work to date
has only looked at the graphical lasso estimator, and not de-sparsifying
nonconvex regularization. Accordingly, it is probably best to set
\code{penalty = "lasso"} in \code{\link{ggmncv}}.

This function only provides the de-sparsified estimator and
not \emph{p}-values or confidence intervals (see \code{\link{inference}}).
}
\examples{
# data
Y <- GGMncv::Sachs[,1:5]

n <- nrow(Y)
p <- ncol(Y)

# fit model
# note: fix lambda, as in the reference
fit <- ggmncv(cor(Y), n = nrow(Y),
              progress = FALSE,
              penalty = "lasso",
              lambda = sqrt(log(p)/n))

# fit model
# note: no regularization
fit_non_reg <- ggmncv(cor(Y), n = nrow(Y),
                      progress = FALSE,
                      penalty = "lasso",
                      lambda = 0)


# remove (some) bias and sparsity
That <- desparsify(fit)

# graphical lasso estimator
fit$P

# de-sparsified estimator
That$P

# mle
fit_non_reg$P
}
\references{
\insertAllCited{}
}
