% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_set.r
\name{create_image_set}
\alias{create_image_set}
\title{Create a curve set of images}
\usage{
create_image_set(image_set, ...)
}
\arguments{
\item{image_set}{A list containing elements \code{r}, \code{obs}, \code{sim_m} and \code{theo}.
\code{r}, \code{sim_m} and \code{theo} are optional, \code{obs} needs to be provided always.
If provided, \code{r} must be a \code{list} describing the argument values
where the images have been observed (or simulated). It must consist of the following two or
four components:
a) "x" and "y" giving the equally spaced argument values for the x- and y-coordinates
(first and second dimension of the 2d functions) where the data have been observed,
b) "x", "y", "width" and "height", where the width and height give the width and height of the
pixels placed at x and y, or
c) "xmin", "xmax", "ymin" and "ymax" giving the corner coordinates of the pixels
where the data have been observed.
If not given, r is set to be a list of values from 1 to the number of first/second dimension
of 2d functions in \code{obs}.
\code{obs} must be either a 2d matrix (dimensions matching the lengths of r vectors)
or 3d array containing the observed 2d functions (the third dimension matching the number
of functions).
If \code{obs} is a 3d array, then \code{sim_m} is ignored.
If \code{obs} is a 2d array, then \code{sim_m} must be a 3d array containing the simulated
images (2d functions) (the third dimension matching the number of functions).
If included, \code{theo} corresponds to the theoretical function
(e.g., under the null hypothesis) and its dimensions must either match the dimensions
of 2d functions in \code{obs} or it must be a constant.}

\item{...}{Do not use. (For internal use only.)}
}
\value{
The given list as a \code{curve_set}.
}
\description{
Create a curve set consisting of a set of images, given a list containing
the values of the 2d functions in the right form.
Only 2d functions in a rectangular windows are supported; the values are provided
in matrices (arrays). For more general 2d functions see \code{\link{create_curve_set}}.
}
\examples{
a <- create_image_set(list(obs=array(runif(4*5*6), c(4,5,6))))
plot(a)
plot(a, idx=1:6)

a <- create_image_set(list(r=list(x=c(10,20,30,40), y=1:5*0.1),
                           obs=array(runif(4*5*6), c(4,5,6))))
plot(a)

a <- create_image_set(list(r=list(xmin=c(1, 2, 4, 7), xmax=c(2, 4, 7, 11),
                                  ymin=c(1,1.1,2,2.1,3), ymax=c(1.1,2,2.1,3,3.1)),
                           obs=array(runif(4*5*6), c(4,5,6))))
plot(a)
plot(a, idx=1:5)
}
