% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_set.r
\name{create_image_set}
\alias{create_image_set}
\title{Create an image set out of a list in the right form.}
\usage{
create_image_set(image_set, ...)
}
\arguments{
\item{image_set}{A list containing elements \code{r}, \code{obs}, \code{sim_m} and \code{theo}.
\code{r}, \code{sim_m} and \code{theo} are optional, \code{obs} needs to be provided always.
If provided, \code{r} must be a \code{\link{data.frame}} describing the argument values
where the images have been observed (or simulated). It must consist of the following two or
four components:
a) "x" and "y" giving the equally spaced argument values for the x- and y-coordinates
(first and second dimension of the 2d functions) where the data have been observed,
b) "x", "y", "width" and "height", where the width and height give the width and height of the
pixels placed at x and y, or
c) "xmin", "xmax", "ymin" and "ymax" giving the corner coordinates of the pixels
where the data have been observed.
If not given, r is set to be a list of values from 1 to the number of first/second dimension
of 2d functions in \code{obs}.
\code{obs} must be either a 2d matrix (dimensions matching the lengths of r vectors)
or 3d array containing the observed 2d functions (the third dimension matching the number
of functions).
If \code{obs} is a 3d array, then \code{sim_m} is ignored.
If \code{obs} is a 2d array, then \code{sim_m} must be a 3d array containing the simulated
images (2d functions) (the third dimension matching the number of functions).
If included, \code{theo} corresponds to the theoretical function
(e.g., under the null hypothesis) and its dimensions must either match the dimensions
of 2d functions in \code{obs} or it must be a constant.}

\item{...}{Do not use. (For internal use only.)}
}
\value{
The given list adorned with the proper class name.
}
\description{
Create an image set out of a list in the right form containing the values of the 2d functions.
Only 2d functions in a rectangular windows are currently supported; the values are provided
in matrices (arrays).
}
