% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.R
\name{frank.flm}
\alias{frank.flm}
\title{F rank functional GLM}
\usage{
frank.flm(nsim, formula.full, formula.reduced, curve_sets,
  factors = NULL, savefuns = TRUE, ..., GET.args = NULL,
  mc.cores = 1, mc.args = NULL, cl = NULL, fast = TRUE)
}
\arguments{
\item{nsim}{The number of random permutations.}

\item{formula.full}{The formula specifying the general linear model,
see \code{formula} in \code{\link[stats]{lm}}.}

\item{formula.reduced}{The formula of the reduced model with nuisance factors only. This model
should be nested within the full model.}

\item{curve_sets}{A named list of sets of curves giving the dependent variable (Y), and
possibly additionally all the factors. The dimensions of the elements should
match with each other, i.e. the factor values should be given for each argument value
and each function. If factors are given in the argument \code{factors}, then can also be just
the curve set representing Y. Also \code{\link[fda.usc]{fdata}} objects allowed.}

\item{factors}{A data frame of factors. An alternative way to specify factors when they
are constant for all argument values. The number of rows of the data frame should be equal
to the number of curves. Each column should specify the values of a factor.}

\item{savefuns}{Logical. If TRUE, then the functions from permutations are saved to the attribute
simfuns.}

\item{...}{Additional arguments to be passed to \code{\link[stats]{lm}}. See details.}

\item{GET.args}{A named list of additional arguments to be passed to \code{\link{global_envelope_test}}.}

\item{mc.cores}{The number of cores to use, i.e. at most how many child processes will be run simultaneously.
Must be at least one, and parallelization requires at least two cores. On a Windows computer mc.cores must be 1
(no parallelization). For details, see \code{\link{mclapply}}, for which the argument is passed.
Parallelization can be used in generating simulations and in calculating the second stage tests.}

\item{mc.args}{A named list of additional arguments to be passed to \code{\link{mclapply}}.
Only relevant if \code{mc.cores} is more than 1.}

\item{cl}{Allows parallelization through the use of \code{\link{parLapply}} (works also
in Windows), see the argument \code{cl} there, and examples.}

\item{fast}{Logical. See details.}
}
\value{
A \code{global_envelope} object, which can be printed and plotted directly.
}
\description{
Multiple testing in permutation inference for the general linear model (GLM)
}
\details{
The function \code{frank.flm} performs
a nonparametric test of significance of a covariate in the functional GLM.
Similarly as in the graphical functional GLM (\code{\link{graph.flm}}),
the Freedman-Lane algorithm (Freedman and Lane, 1983) is applied to permute the functions
(to obtain the simulations under the null hypothesis of "no effects");
consequently, the test approximately achieves the desired significance level.
In contrast to the graphical functional GLM, the F rank functional GLM is based on the
F-statistics that are calculated at each argument value of the functions.
The global envelope test is applied to the observed and simulated F-statistics.
The test is able to find if the factor of interest is significant and also which
argument values of the functional domain are responsible for the potential rejection.

The specification of the full and reduced formulas is important. The reduced model should be
nested within the reduced model. The full model should include in addition to the reduced
model the interesting factors whose effects are under investigation. Please avoid use of
'*' when specifying interactions, e.g. factor1*factor2; instead explicitly specify all
components of the model.

There are different versions of the implementation depending on the application.
Given that the argument \code{fast} is TRUE, then
\itemize{
\item If all the covariates are constant across the functions, i.e. they can be provided in the
argument \code{factors}, then a linear model is fitted separately by least-squares estimation to
the data at each argument value of the functions fitting a multiple linear model by \code{\link[stats]{lm}}.
The possible extra arguments passed in \code{...} to \code{\link[stats]{lm}} must be of the form that
\code{\link[stats]{lm}} accepts for fitting a multiple linear model. In the basic case, no extra arguments are
needed.
\item If some of the covariates vary across the space, i.e. they are provided in the list of curve sets in
the argument \code{curve_sets} together with the dependent functions, but there are no extra arguments given
by the user in \code{...}, there is a rather fast implementation of the F-value calculation (which does not
use \code{\link[stats]{lm}}).
\item If some of the covariates vary across the space and there are user specified extra arguments given in
\code{...}, then the implementation fits a linear model at each argument value of the functions using
\code{\link[stats]{lm}}, which can be rather slow. The arguments \code{...} are passed to \code{\link[stats]{lm}}
for fitting each linear model.
}
By setting \code{fast = FALSE}, the latter version is used even in a case where faster implementation would be
available. Usually this is not desired.
}
\examples{
data(GDPtax)
factors.df <- data.frame(Group = GDPtax$Group, Tax = GDPtax$Profittax)
\donttest{
res.tax_within_group <- frank.flm(nsim = 999,
                                  formula.full = Y~Group+Tax+Group:Tax,
                                  formula.reduced = Y~Group+Tax,
                                  curve_sets = list(Y=GDPtax$GDP),
                                  factors = factors.df)
}
\dontshow{
res.tax_within_group <- frank.flm(nsim = 4,
                                  formula.full = Y~Group+Tax+Group:Tax,
                                  formula.reduced = Y~Group+Tax,
                                  curve_sets = list(Y=GDPtax$GDP),
                                  factors = factors.df,
                                  GET.args = list(alpha=0.20))
}
plot(res.tax_within_group)
}
\references{
Mrkvička, T., Myllymäki, M. and Narisetty, N. N. (2019) New methods for multiple testing in permutation inference for the general linear model. arXiv:1906.09004 [stat.ME]

Freedman, D., & Lane, D. (1983) A nonstochastic interpretation of reported significance levels. Journal of Business & Economic Statistics, 1(4), 292-298. doi:10.2307/1391660
}
