% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMSDP.R
\name{AMSDP}
\alias{AMSDP}
\title{Additive-Mean-Standard-Deviation Portfolio Utility Function}
\usage{
AMSDP(x, mp, Cov, gamma = 1, theta = 1)
}
\arguments{
\item{x}{a numeric n-vector representing a portfolio.}

\item{mp}{a numeric n-vector representing the mean payoff of each of the n securities.}

\item{Cov}{the n-by-n covariance matrix of the payoff vectors of n securities.}

\item{gamma}{the risk aversion coefficient.}

\item{theta}{a non-negative scalar with a default value of 1.}
}
\description{
Compute the utility function x \%*\% mp - gamma^theta * (t(x) \%*\% Cov \%*\% x)^(0.5 * theta) / theta for a portfolio x.
}
\references{
Danthine, J. P., Donaldson, J. (2005, ISBN: 9780123693808) Intermediate Financial Theory. Elsevier Academic Press.

Nakamura, Yutaka (2015) Mean-Variance Utility. Journal of Economic Theory, 160: 536-556.

Sharpe, William F (2008, ISBN: 9780691138503) Investors and Markets: Portfolio Choices, Asset Prices, and Investment Advice. Princeton University Press.

Xu Gao (2018, ISBN: 9787300258232) Twenty-five Lectures on Financial Economics. Beijing: China Renmin University Press. (In Chinese)
}
\seealso{
\code{\link{AMSD}}
}
