% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemInputOutputTable_2_8_4.R
\name{gemInputOutputTable_2_8_4}
\alias{gemInputOutputTable_2_8_4}
\title{A Two-Country General Equilibrium Model with Money}
\usage{
gemInputOutputTable_2_8_4(
  IT,
  product.output.CHN = sum(IT[, "production.CHN"]),
  product.output.ROW = sum(IT[, "production.ROW"]),
  labor.supply.CHN = sum(IT["labor.CHN", ]),
  labor.supply.ROW = sum(IT["labor.ROW", ]),
  capital.supply.CHN = sum(IT["capital.CHN", ]),
  capital.supply.ROW = sum(IT["capital.ROW", ]),
  money.interest.supply.CHN = 5,
  money.interest.supply.ROW = 30,
  es.productDI.production.CHN = 0.5,
  es.productDI.production.ROW = 0.5,
  es.laborCapital.production.CHN = 0.75,
  es.laborCapital.production.ROW = 0.75,
  es.consumption.CHN = 0.5,
  es.consumption.ROW = 0.5,
  es.investment.CHN = 0.9,
  es.investment.ROW = 0.9,
  interest.rate.CHN = NA,
  interest.rate.ROW = NA,
  return.dstl = FALSE,
  ...
)
}
\arguments{
\item{IT}{the input part of the input-output table (unit: trillion yuan).}

\item{product.output.CHN}{the product output of the production sector of CHN.}

\item{product.output.ROW}{the product output of the production sector of ROW.}

\item{labor.supply.CHN}{the labor supply of CHN.}

\item{labor.supply.ROW}{the labor supply of ROW.}

\item{capital.supply.CHN}{the capital supply of CHN.}

\item{capital.supply.ROW}{the capital supply of ROW.}

\item{money.interest.supply.CHN}{the money interest supply of CHN,
that is, the exogenous money supply multiplied by the exogenous interest rate.}

\item{money.interest.supply.ROW}{the money interest supply of ROW.}

\item{es.productDI.production.CHN}{the elasticity of substitution between
domestic product and imported product used by the production sector of CHN.}

\item{es.productDI.production.ROW}{the elasticity of substitution between
domestic product and imported product used by the production sector of ROW.}

\item{es.laborCapital.production.CHN}{the elasticity of substitution between
labor and capital goods used by the production sector of CHN.}

\item{es.laborCapital.production.ROW}{the elasticity of substitution between
labor and capital goods used by the production sector of ROW.}

\item{es.consumption.CHN}{the elasticity of substitution between
domestic product and imported product used by the consumption sector of CHN.}

\item{es.consumption.ROW}{the elasticity of substitution between
domestic product and imported product used by the consumption sector of ROW.}

\item{es.investment.CHN}{the elasticity of substitution between
domestic product and imported product used by the investment sector of CHN.}

\item{es.investment.ROW}{the elasticity of substitution between
domestic product and imported product used by the investment sector of ROW.}

\item{interest.rate.CHN}{the interest rate of CHN.}

\item{interest.rate.ROW}{the interest rate of ROW.}

\item{return.dstl}{If TRUE, the demand structure tree will be returned.}

\item{...}{arguments to be transferred to the function sdm of the package CGE.}
}
\value{
A general equilibrium, which usually is a list with the following elements:
\itemize{
\item p - the price vector with CHN labor as numeraire, wherein
the price of a currency is the interest per unit of currency.
\item D - the demand matrix, also called the input table. Wherein the benchmark prices are used.
\item DV - the demand value matrix, also called the value input table. Wherein the current price is used.
\item SV - the supply value matrix, also called the value output table. Wherein the current price is used.
\item eri.CHN - the exchange rate index of CHN currency.
\item eri.ROW - the exchange rate index of ROW currency.
\item p.money - the price vector with CHN money as numeraire
if both interest.rate.CHN and interest.rate.CHN are not NA.
\item dstl - the demand structure tree list of sectors if return.dstl == TRUE.
\item ... - some elements returned by the CGE::sdm function
}
}
\description{
A two-country general equilibrium model with money.
This general equilibrium model is based on a two-country (i.e. CHN and ROW) input-output table.
Each country contains four sectors and eight commodities (or subjects).
The four sectors are production, consumption, investment and foreign trade.
The eight commodities (or subjects) are product, labor, capital goods, bond, tax, dividend, imported product and money interest.
Hence the input-output table has 16 rows and 8 columns.
}
\details{
If interest.rate.CHN is NA or interest.rate.CHN is NA, they are assumed to be equal.
And in this case, the exchange rate is determined by the ratio of the interest of unit currency of the two countries.
In this model, the ratio of a sector's monetary interest expenditure to its transaction value may not be equal to the interest rate
because the ratio is not only affected by the interest rate,
but also by the sector's currency circulation velocity and other factors.
}
\examples{
\donttest{
ITExample <- matrix(0, 16, 8, dimnames = list(
  c(
    "product.CHN", "labor.CHN", "capital.CHN", "bond.CHN",
    "tax.CHN", "dividend.CHN", "imported.product.CHN", "money.interest.CHN",
    "product.ROW", "labor.ROW", "capital.ROW", "bond.ROW",
    "tax.ROW", "dividend.ROW", "imported.product.ROW", "money.interest.ROW"
  ),
  c(
    "production.CHN", "consumption.CHN", "investment.CHN", "foreign.trade.CHN",
    "production.ROW", "consumption.ROW", "investment.ROW", "foreign.trade.ROW"
  )
))

production.CHN <- c(
  product.CHN = 140, labor.CHN = 40, capital.CHN = 10,
  tax.CHN = 10, dividend.CHN = 20, imported.product.CHN = 5, money.interest.CHN = 5
)
production.ROW <- c(
  product.ROW = 840, labor.ROW = 240, capital.ROW = 60,
  tax.ROW = 60, dividend.ROW = 120, imported.product.ROW = 6, money.interest.ROW = 30
)

consumption.CHN <- c(
  product.CHN = 40, bond.CHN = 30, imported.product.CHN = 5, money.interest.CHN = 2
)

consumption.ROW <- c(
  product.ROW = 240, bond.ROW = 180, imported.product.ROW = 6, money.interest.ROW = 12
)

investment.CHN <- c(
  product.CHN = 30,
  imported.product.CHN = 4, money.interest.CHN = 1,
  bond.ROW = 1,
  money.interest.ROW = 0.02
)

investment.ROW <- c(
  bond.CHN = 1,
  money.interest.CHN = 0.02,
  product.ROW = 180,
  imported.product.ROW = 4, money.interest.ROW = 6
)


foreign.trade.CHN <- c(
  product.ROW = 13,
  tax.CHN = 0.65,
  money.interest.ROW = 0.26
)

foreign.trade.ROW <- c(
  product.CHN = 15,
  tax.ROW = 0.75,
  money.interest.CHN = 0.3
)

ITExample <- matrix_add_by_name(
  ITExample, production.CHN, consumption.CHN, investment.CHN, foreign.trade.CHN,
  production.ROW, consumption.ROW, investment.ROW, foreign.trade.ROW
)

ge <- gemInputOutputTable_2_8_4(
  IT = ITExample,
  return.dstl = TRUE
)
ge$eri.CHN
ge$p
dst_plot(ge$dstl[[4]])

ge2 <- gemInputOutputTable_2_8_4(
  IT = ge$DV,
  money.interest.supply.CHN = sum(ge$DV["money.interest.CHN", ]),
  money.interest.supply.ROW = sum(ge$DV["money.interest.ROW", ]),
  return.dstl = TRUE
)
ge2$eri.CHN
ge2$p


#### technology progress in CHN
ITTmp <- ITExample
ITTmp["labor.CHN", "production.CHN"] <- ITTmp["labor.CHN", "production.CHN"] * 0.8
geTmp <- gemInputOutputTable_2_8_4(
  IT = ITTmp,
  product.output.CHN = sum(ITExample[, "production.CHN"]),
  return.dstl = TRUE
)
geTmp$eri.CHN


#### increased demand for imported product in CHN
ITTmp <- ITExample
ITTmp["imported.product.CHN", "production.CHN"] <-
  ITTmp["imported.product.CHN", "production.CHN"] * 1.2
geTmp <- gemInputOutputTable_2_8_4(
  IT = ITTmp,
  return.dstl = TRUE
)
geTmp$eri.CHN


#### capital accumulation in CHN
geTmp <- gemInputOutputTable_2_8_4(
  IT = ITExample,
  capital.supply.CHN = sum(ITExample["capital.CHN", ]) * 1.2,
  return.dstl = TRUE
)
geTmp$eri.CHN

##
geTmp <- gemInputOutputTable_2_8_4(
  IT = ITExample,
  capital.supply.CHN = sum(ITExample["capital.CHN", ]) * 1.2,
  es.productDI.production.CHN = 0.3,
  return.dstl = TRUE
)
geTmp$eri.CHN
}

}
