% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_ss_cor.R
\name{estimate_ss_cor}
\alias{estimate_ss_cor}
\title{estimate_ss_cor.R}
\usage{
estimate_ss_cor(ref_pcs, ref_genotypes, link_function)
}
\arguments{
\item{ref_pcs}{An n*m matrix containing PCs calculated from the reference panel. Here n is the
number of subjects in the reference panel and m is roughly the number of PCs used in the original
analysis which produced the summary statistics.}

\item{ref_genotypes}{An n*d matrix holding the genotypes from the reference panel, where the d columns
correspond to the d SNPs for which we have summary statistics. No missing data allowed.}

\item{link_function}{Either "linear" or "logit" or "log".}
}
\value{
A list with the elements:
\item{cor_mat}{The d*d matrix giving the pairwise correlation of every two test statistics.}
}
\description{
Estimate the correlations between GWAS summary statistics using reference panel eigenvectors
and reference panel genotypes.
}
\examples{
ref_pcs <- matrix(data=runif(n=1000, min=-0.2, max=0.2), ncol=5)
ref_genotypes <- matrix(data=rbinom(n=2000, size=2, prob=0.3), ncol=10)
estimate_ss_cor(ref_pcs=ref_pcs, ref_genotypes=ref_genotypes, link_function="linear")
}
