\name{gadm.getBackground}
\alias{gadm.getBackground}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Gets tiles with 'rosm' from OpenStreetMap}
\description{
Load tiles from OpenStreetMap  create and save a .tif file with assembled tiles. The bounding box is automatically retrieved from the GADM shapefile passed as argument. The .tif file is stored in the working directory. 
}
\usage{
gadm.getBackground(x, name, type="osm", clip=TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
\bold{GADMWrapper Object} of the region that you want to add a background.
}
  \item{name}{
\bold{character} the name of the TIFF file generated by this function. The .tif extension is automaticaly added. 
}
  \item{type}{
\bold{Character} type (default "osm') of the map provided by osm.types().
}
  \item{clip}{
\bold{boolean} if TRUE (the default), background is clipped by the the external border of the spatial object. If FALSE, spatial object is drawn upper the background using the full bounding box.
}

}

\value{ \bold{Object} GADMWrapper }

\references{
----}
\author{Jean Pierre Decorps <jp.decorps@epiconcept.fr>}
\note{
----
}

\seealso{\code{\link{osm.types}}}

\examples{
# library(GADMTools)
# library(rosm)
# FRA = gadm.loadCountries("FRA", 2, basefile = "./")
# BRE = GADMTools::subset(FRA, level=1, regions=c("Bretagne"))
# BRE2 <- gadm.getBackground(BRE, "BRE", "osm")
# plotmap(BRE2, title = "Map of Bretagne (FRANCE)")
}
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
