% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_gadget_infile.R
\name{create_gadget_infile}
\alias{create_gadget_infile}
\title{Create GADGET input files}
\usage{
create_gadget_infile(lhs_design, response, filename)
}
\arguments{
\item{lhs_design}{design matrix of DC evaluations}

\item{response}{vector of DC responses}

\item{filename}{save design to this file}
}
\description{
This utility function will save batch evaluated design criterion (DC) responses to seed the design_experiment function.
}
\examples{
#produces an Rdata file containing previous runs of the design criterion
set.seed(123)
lhs_design         <- lhs::maximinLHS(10,1)
criterion_response <- (lhs_design - 1)^2
file               <- paste(tempdir(),"/gadget_infile.Rdata", sep="")
create_gadget_infile(lhs_design,criterion_response, filename = file)
message(sprintf("gadget_infile.Rdata saved to directory \%s",tempdir()))

}
