% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ind_Evaluation_30112018.R
\name{Ri}
\alias{Ri}
\title{Calculates the indicator of information's rate of the data base for a given unit}
\usage{
Ri(x, i, b_jk, SI)
}
\arguments{
\item{x}{the data set to evaluate.}

\item{i}{an observation index.}

\item{b_jk}{a matrix of length(b_j) rows and max(SI) columns expressing the initial weights of each sub-item of a given main-item.}

\item{SI}{an array representing the total numbers of sub-items per main-item.}
}
\value{
A numerical value giving the indicator of information's rate of the complete linguistic questionnaire for a particular observation. Note that the obtained value is interpreted as the more it tends to the value 1, the less the observation i contains missing values.
}
\description{
Calculates the indicator of information's rate of the data base for a given unit
}
\examples{
data <- matrix(c(3,4,2,3,3,2,4,3,3,4,3,4,4,2,5,3,4,4,3,3,3,4,4,3,
3,3,4,3,3,3,3,4,4,3,5,3,4,3,3,3), ncol = 4)
data <- as.data.frame(data)
SI1 <- 2
SI2 <- 2
SI <- c(SI1,SI2)
b_jk <- matrix(c(0.5,0.5,0.5,0.5),nrow=2) 
Ri(data, 7, b_jk, SI)
}
