% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussFN_30112018.R
\name{GaussianFuzzyNumber}
\alias{GaussianFuzzyNumber}
\title{Creates a Gaussian fuzzy number}
\usage{
GaussianFuzzyNumber(
  mean,
  sigma,
  alphacuts = FALSE,
  margin = c(5, 5),
  step = 0.01,
  breakpoints = 100,
  precision = 4,
  plot = FALSE
)
}
\arguments{
\item{mean}{a numerical value of the parameter mu of the Gaussian curve.}

\item{sigma}{a numerical value of the parameter sigma of the Gaussian curve.}

\item{alphacuts}{fixed by default to "FALSE". No alpha-cuts are printed in this case.}

\item{margin}{an optional numerical couple of values representing the range of calculations of the Gaussian curve written as [mean - 3*sigma; mean + 3*sigma] by default.}

\item{step}{a numerical value fixing the step between two knots dividing the interval [mean - 3*sigma; mean + 3*sigma].}

\item{breakpoints}{a positive arbitrary integer representing the number of breaks chosen to build the numerical alpha-cuts. It is fixed to 100 by default.}

\item{precision}{an integer specifying the number of decimals for which the calculations are made. These latter are set by default to be at the order of 1/10^4 .}

\item{plot}{fixed by default to "FALSE". plot="TRUE" if a plot of the fuzzy number is required.}
}
\value{
If the parameter alphacuts="TRUE", the function returns a matrix composed by 2 vectors representing the left and right alpha-cuts. For this output, is.alphacuts = TRUE. If the parameter alphacuts="FALSE", the function returns a list composed by the Class, the mean, the sigma, the vectors of the left and right alpha-cuts.
}
\description{
Creates a Gaussian fuzzy number
}
\examples{
GFN <- GaussianFuzzyNumber(mean = 0, sigma = 1, alphacuts = TRUE, plot=TRUE)
is.alphacuts(GFN)
}
