% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneratorFuzzyNumbers.R
\name{GeneratorFuzzyNumbers}
\alias{GeneratorFuzzyNumbers}
\title{Generate initial sample using various random distributions.}
\usage{
GeneratorFuzzyNumbers(
  n,
  originalRandomDist,
  parametersOriginalRD,
  increasesRandomDist,
  parametersIncreasesRD,
  supportLeftRandomDist,
  parametersSupportLeftRD,
  supportRightRandomDist,
  parametersSupportRightRD,
  increases = FALSE,
  ...
)
}
\arguments{
\item{n}{Number of fuzzy trapezoidal numbers in the created sample.}

\item{originalRandomDist}{Name of the random generator used to create the "true origin" of fuzzy trapezoidal number (as
defined in \code{stats} package).}

\item{parametersOriginalRD}{List of parameters required by the random generator used
to create the "true origin" of fuzzy trapezoidal number.}

\item{increasesRandomDist}{Name of the random generator used to create the increases of the core of fuzzy
trapezoidal number (as defined in \code{stats} package).}

\item{parametersIncreasesRD}{List of parameters required by the random generator used
to create the increases of the core of fuzzy trapezoidal number.}

\item{supportLeftRandomDist}{Name of the random generator used to create the increases of the left support of fuzzy
trapezoidal number (as defined in \code{stats} package).}

\item{parametersSupportLeftRD}{List of parameters required by the random generator used
to create the increases of the left support of fuzzy trapezoidal number.}

\item{supportRightRandomDist}{Name of the random generator used to create the increases of the right support of fuzzy
trapezoidal number (as defined in \code{stats} package).}

\item{parametersSupportRightRD}{List of parameters required by the random generator used
to create the increases of the right support of fuzzy trapezoidal number.}

\item{increases}{If \code{TRUE} is used, then the output fuzzy numbers are given in the form:
left increment of the support, left end of the core, right end of the core,
right increment of the support. Otherwise, the default value \code{FALSE} is used and the fuzzy numbers are given in the form:
left end of the support, left end of the core, right end of the core,
right end of the support.}

\item{...}{Some additional parameters to pass to other functions.}
}
\value{
This function returns matrix which consists of \code{n} trapezoidal fuzzy numbers.
Each fuzzy number (four values) ia given as one row in this matrix.
}
\description{
\code{GeneratorFuzzyNumbers} generates the random sample of trapezoidal fuzzy numbers using the
various random distributions, using the functions from the \code{stats} package.
}
\details{
The procedure simulates the initial sample which consists of \code{n} trapezoidal fuzzy numbers.
The "true origin" of each fuzzy number is independently drawn from the random distribution using
\code{originalRandomDist} function from the \code{stats} package with the parameters defined by
\code{parametersOriginalRD}.
The same applies to the increases of the core (the function \code{increasesRandomDist} with the parameters
\code{parametersIncreasesRD} is then used), the left increase of the support (the function \code{supportLeftRandomDist}
with the parameters \code{parametersSupportLeftRD}, respectively), and the right increase of the support
(the function \code{supportRightRandomDist}
with the parameters \code{parametersSupportRightRD}, respectively).

Names of these generators for random probabilities and their respective parameters should be in the form
required by \code{stats} package.

The output is given as a matrix.
In each row, there is a single fuzzy number in one of the forms:
\enumerate{
\item left end of the support, left end of the core, right end of the core, right end of the support, or
\item left increment of the support, left end of the core, right end of the core, right increment of the support.
}
To obtain this second form, the parameter \code{increases=TRUE} has to be used.
}
\examples{

# seed PRNG

set.seed(1234)

# generate 10 trapezoidal fuzzy numbers (the normal distribution for the "true origin",
# the exponential distribution for the increases of the core, and two different uniform
# distribution for the increases of the support)

GeneratorFuzzyNumbers(10,"rnorm",list(mean=0,sd=1),"rexp",list(rate=2),"runif",
                     list(min=0,max=0.6),"runif",list(min=0,max=1))



}
\references{
Grzegorzewski, P., Hryniewicz, O., Romaniuk, M. (2020)
Flexible resampling for fuzzy data based on the canonical representation
International Journal of Computational Intelligence Systems, 13 (1), pp. 1650-1662

Grzegorzewski, P., Romaniuk, M. (2022)
Bootstrapped Kolmogorov-Smirnov Test for Epistemic Fuzzy Data
Information Processing and Management of Uncertainty in Knowledge-Based Systems
Springer
}
\seealso{
\code{\link{GeneratorNExpUU}}

Other sampling functions: 
\code{\link{GeneratorNExpUU}()},
\code{\link{GeneratorNU}()}
}
\concept{sampling functions}
