% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneratorNExpUU.R
\name{GeneratorNExpUU}
\alias{GeneratorNExpUU}
\title{Generate initial sample using the normal and uniform distributions.}
\usage{
GeneratorNExpUU(n, mu, sigma, lambda, b, c, increases = FALSE, ...)
}
\arguments{
\item{n}{Number of fuzzy trapezoidal numbers in the created sample.}

\item{mu}{The expected value of the normal distribution which is used to create the "true origin" of fuzzy trapezoidal number.}

\item{sigma}{The standard deviation of the normal distribution which is used to create the "true origin" of fuzzy trapezoidal number.}

\item{lambda}{The parameter of the exponential distributions which are used to create the left and right
increases of the core.}

\item{b}{The right end of the interval of the independent uniform distribution which is used to create the left
increase of the support.}

\item{c}{The right end of the interval of the independent uniform distribution which is used to create the right
increase of the support.}

\item{increases}{If \code{TRUE} is used, then the output fuzzy numbers are given in the form:
left increment of the support, left end of the core, right end of the core,
right increment of the support. Otherwise, the default value \code{FALSE} is used and the fuzzy numbers are given in the form:
left end of the support, left end of the core, right end of the core,
right end of the support.}

\item{...}{Some additional parameters to pass to other functions.}
}
\value{
This function returns matrix which consists of \code{n} trapezoidal fuzzy numbers.
Each fuzzy number (four values) ia given as one row in this matrix.
}
\description{
\code{GeneratorNExpUU} generates the random sample of trapezoidal fuzzy numbers using the normal, exponential and uniform distributions (for
the "true" origin of each fuzzy number, and its increases, respectively).
}
\details{
The procedure simulates the initial sample which consists of \code{n} trapezoidal fuzzy numbers.
The "true origin" of each fuzzy number is independently drawn from the normal distribution \code{N (mu, sigma)}.
Then increases of its core are independently generated from the exponential distributions \code{Exp (lambda)}.
The increases of its support are independently drawn from the uniform distributions
\code{U [0,b]} (the left-hand increase) and \code{U [0,c]} (its right-hand counterpart) (see Grzegorzewski et al. (2020)).

The output is given as a matrix.
In each row, there is a single fuzzy number in one of the forms:
\enumerate{
\item left end of the support, left end of the core, right end of the core, right end of the support, or
\item left increment of the support, left end of the core, right end of the core, right increment of the support.
}
To obtain this second form, the parameter \code{increases=TRUE} has to be used.
}
\examples{

# seed PRNG

set.seed(1234)

# generate 10 trapezoidal fuzzy numbers

GeneratorNExpUU(10, 0,1,1,1,2)



}
\references{
Grzegorzewski, P., Hryniewicz, O., Romaniuk, M. (2020)
Flexible resampling for fuzzy data based on the canonical representation
International Journal of Computational Intelligence Systems, 13 (1), pp. 1650-1662
}
\seealso{
\code{\link{GeneratorNU}}

Other sampling functions: 
\code{\link{GeneratorNU}()}
}
\concept{sampling functions}
