% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyOperation.R
\name{fuzzy.t}
\alias{fuzzy.t}
\title{Fuzzy t-norm/t-conorm operation}
\usage{
fuzzy.t(operator, ...)
}
\arguments{
\item{operator}{The supported t-norm/t-conorm operators are min, prod, max}

\item{...}{fuzzy membership functions}
}
\value{
A membership function, which is the t-norm/t-conorm of membership functions
}
\description{
To conduct t-norm or t-conorm operation for given fuzzy member functions
}
\examples{
mf1 <- genmf(gbellmf, c(1,2,3))
mf2 <- genmf(gbellmf, c(4,5,6))
mf3 <- fuzzy.t(max, mf1, mf2)
tmp1 <- evalmf(1:10, mf1)
tmp2 <- evalmf(1:10, mf2)
tmp3 <- evalmf(1:10, mf3)
identical(tmp3, pmax(tmp1, tmp2))
tmp3
}
\author{
Chao Chen
}

