% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureHSD.R
\name{MeasureHSD}
\alias{MeasureHSD}
\title{Function to calculate the HSD distance between two fuzzy numbers.}
\usage{
MeasureHSD(value1, value2, trapezoidal = TRUE)
}
\arguments{
\item{value1}{The first input triangular or trapezoidal fuzzy number.}

\item{value2}{The second input triangular or trapezoidal fuzzy number.}

\item{trapezoidal}{Logical value depending on the type of input fuzzy values (triangular or trapezoidal ones).}
}
\value{
The output is given as a numerical value.
}
\description{
`MeasureHSD` calculates the HSD (Area Hight Distance) measure between two trapezoidal or triangular fuzzy numbers.
}
\details{
The procedure calculates the HSD (Hight Source Distance) measure of the distance between two trapezoidal or triangular fuzzy numbers.
The input values can be given as triangular/trapezoidal fuzzy numbers using the objects defined in \code{FuzzyNumbers} package
or vectors with three (in the case of triangular fuzzy numbers) or four (for trapezoidal fuzzy numbers) values related to
left end of the support, the core (or its interval, respectively), and the right end of the support.
The parameter \code{trapezoidal} is used to indicate if the input values are trapezoidal fuzzy numbers or triangular ones.
}
\examples{



# let's define two trapezoidal fuzzy numbers

tpfn1 <- c(1,2,3,4)

tpfn2 <- c(2,6,8,10)

# calculate the distance

MeasureHSD(tpfn1,tpfn2)

# now we use objects from the FuzzyNumbers package

# load the necessary library

library(FuzzyNumbers)

tpfn1 <- TrapezoidalFuzzyNumber(1,2,3,4)

tpfn2 <- TrapezoidalFuzzyNumber(2,6,8,10)

MeasureHSD(tpfn1,tpfn2)


}
\references{
S. Yeganehmanesh, M. Amirfakhrian, and P. Grzegorzewski, “Fuzzy semi-numbers and a distance on them with a case study in medicine,”
Mathematical Sciences, vol. 12, no. 1, pp. 41–52, 2018
}
\seealso{
\code{\link{MeasureAHD}, \link{MeasureEuclidean}} for other procedures to calculate distance measures.
}
