% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatisticalMeasures.R
\name{StatisticalMeasures}
\alias{StatisticalMeasures}
\title{Calculation of statistical measures for errors of the imputed data.}
\usage{
StatisticalMeasures(trueData, imputedData, imputedMask, ...)
}
\arguments{
\item{trueData}{Name of the input matrix (or data frame) with the true values of the variables.}

\item{imputedData}{Name of the input matrix (or data frame) with the imputed values.}

\item{imputedMask}{Matrix (or data frame) with logical values where \code{TRUE} indicates the cells with the imputed values.}

\item{...}{Additional parameters passed to other functions.}
}
\value{
The output is given as a matrix.
}
\description{
\code{StatisticalMeasures} calculates various statistical measures between the real and imputed data.
}
\details{
The procedure calculates different statistical measures between the real and
imputed data for each column, namely:
\itemize{
\item TrueMean - the mean only for the real but missing data,
\item ImpMean - the mean only for the imputed values,
\item TrueSD - the standard deviation only for the real but missing data,
\item ImpSD - the standard deviation only for the imputed values,
\item GenMean - the mean for the all real data (given by \code{trueData}),
\item GenImpMean - the mean for real data with the respectively imputed values (given by \code{imputedData}),
\item GenSD - the standard deviation for the all real data (given by \code{trueData}),
\item GenImpSD - the standard deviation for real data with the respectively imputed values (given by \code{imputedData}),
\item AbsDiffTrueImpMean - the absolute difference between TrueMean and ImpMean,
\item AbsDiffTrueImpSD - the absolute difference between TrueSD and ImSD,
\item AbsDiffGenImpMean - the absolute difference between GenMean and GenImpMean,
\item AbsDiffGenImpSD - the absolute difference between GenSD and GenImpSD.
}

To properly distinguish the real values with their imputed counterparts, the additional matrix \code{imputedMask} should be provided.
In this matrix, the logical value \code{TRUE} points out the cells with the imputed values.
Otherwise, \code{FALSE} should be used. These input datasets should be given as matrices
or data frames.
}
\examples{

# seed PRNG

set.seed(1234)

# load the necessary library

library(FuzzySimRes)

# generate sample of trapezoidal fuzzy numbers with FuzzySimRes library

list1<-SimulateSample(20,originalPD="rnorm",parOriginalPD=list(mean=0,sd=1),
incrCorePD="rexp", parIncrCorePD=list(rate=2),
suppLeftPD="runif",parSuppLeftPD=list(min=0,max=0.6),
suppRightPD="runif", parSuppRightPD=list(min=0,max=0.6),
type="trapezoidal")

# convert fuzzy data into a matrix

matrix1 <- FuzzyNumbersToMatrix(list1$value)

# check starting values

head(matrix1)

# add some NAs to the matrix

matrix1NA <- IntroducingNA(matrix1,percentage = 0.1)

head(matrix1NA)

# impute missing values

matrix1DImp <- ImputationDimp(matrix1NA)

# find cells with NAs

matrix1Mask <- is.na(matrix1NA)

# calculate errors for the imputed values

StatisticalMeasures(matrix1,matrix1DImp,matrix1Mask)


}
