% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-FuzzyPairwiseComparisonMatrix.R
\docType{methods}
\name{fuzzyPairwiseComparisonMatrix}
\alias{fuzzyPairwiseComparisonMatrix}
\alias{fuzzyPairwiseComparisonMatrix,PairwiseComparisonMatrix}
\alias{fuzzyPairwiseComparisonMatrix,PairwiseComparisonMatrix,fuzzyScale-method}
\alias{fuzzyPairwiseComparisonMatrix,PairwiseComparisonMatrix-method}
\alias{fuzzyPairwiseComparisonMatrix,matrix-method}
\title{Function that creates Fuzzy Pairwise Comparions Matrix}
\usage{
fuzzyPairwiseComparisonMatrix(pairwiseComparisonMatrix, fuzzyScale,
comparsionNotInScale, width)


  \S4method{fuzzyPairwiseComparisonMatrix}{PairwiseComparisonMatrix}(pairwiseComparisonMatrix,
  fuzzyScale = getFuzzyScale(type = "full"), comparsionNotInScale = FALSE,
  width = 1)

\S4method{fuzzyPairwiseComparisonMatrix}{matrix}(pairwiseComparisonMatrix)
}
\arguments{
\item{pairwiseComparisonMatrix}{\linkS4class{PairwiseComparisonMatrix} or \code{matrix}.}

\item{fuzzyScale}{A numeric vector that definies fuzzy scale. Default scale is described in details.}

\item{comparsionNotInScale}{A boolean variable. If \code{TRUE} the intensities not found in
\code{fuzzyScale} are calculated with use of \code{width} parameter. Default value \code{FALSE}.}

\item{width}{A numeric parameter, specifying the width of calculated fuzzy intensity. If
\code{comparsionNotInScale} is \code{FALSE} then the parameter is not considered.
Default value \code{1}.}
}
\value{
Object of class \linkS4class{FuzzyPairwiseComparisonMatrix}
}
\description{
This methods construct object \linkS4class{FuzzyPairwiseComparisonMatrix} based on provided
\linkS4class{PairwiseComparisonMatrix} and an optional fuzzy scale.
}
\details{
Parameter fuzzyScale is expected as a vector containing n*3 values that represent triangular fuzzy
numbers used as fuzzy intensity of importance (only the values equal or higher than 1, inverse values
are calculated automatically). The values need to be ordered by fuzzy values. Default value of this
parameter is \code{as.double(c(1/2,1,2,1,2,3,2,3,4,3,4,5,4,5,6,5,6,7,6,7,8,7,8,9,8,9,9))}. Another
possibility is eg. \code{as.double(c(1/3,1,3,1,3,5,3,5,7,5,7,9,7,9,9))}

If param \code{pairwiseComparisonMatrix} is \code{matrix} then it needs to be of \code{character} type.
Each element in the matrix must be specified as triplet \code{"x;y;z"}, where \code{x<=y<=z}.
From this matrix a pairwise comparison is constructed from \code{y} values and \code{x} and \code{z}
function as lower and upper limits of \code{y} respectively. In this case the optional parameter
\code{fuzzyScale} is not taken into account at all.
}

