% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_limits_lookup.R
\name{build_limits_lookup}
\alias{build_limits_lookup}
\title{Function to build funnel limits}
\usage{
build_limits_lookup(
  min_x,
  max_x,
  min_y,
  max_y,
  Poisson_limits,
  OD_adjust,
  tau2,
  data_type,
  sr_method,
  target,
  multiplier
)
}
\arguments{
\item{Poisson_limits}{TRUE/FALSE Draw Poisson distribution limits?}

\item{OD_adjust}{TRUE/FALSE Use overdispersion adjustment}

\item{tau2}{If using OD_adjust, what is the tau2 ("between" standard error) to use?}

\item{data_type}{SR, PR or RC. Used to set target reference}

\item{sr_method}{Which adjustment method is being used, SHMI or CQC?}

\item{target}{target to be used to set centre line}

\item{multiplier}{Multiply ratio value by an amount.  Default is 1, but some mortality ratios use 100, for example.}

\item{min_preds}{Minimum predicted value for range of x-axis}

\item{max_preds}{Maximum predicted value for range of x-axis}

\item{min_ratio}{Minimum ratio value for range of y-axis}

\item{max_ratio}{Maximum ratio value for range of y-axis}
}
\value{
A data.frame with an index column and various control limits based on the index as an x-axis value.
}
\description{
Internal function for funnel plot to build the control limits prior to plotting.
}
\keyword{internal}
