% Generated by roxygen2 (4.0.1): do not edit by hand
\name{JackPEL}
\alias{JackPEL}
\title{Confidence intervals for the pseudo empirical likelihood estimator based on jackknife method}
\usage{
JackPEL(ysA, ysB, pi_A, pi_B, domains_A, domains_B, N_A = NULL, N_B = NULL,
N_ab = NULL, XsAFrameA = NULL, XsBFrameA = NULL, XsAFrameB = NULL, XsBFrameB = NULL,
XA = NULL, XB = NULL, conf_level, sdA = "srs", sdB = "srs", nhA = NULL, NhA = NULL,
nhB = NULL, NhB = NULL, fcpA = FALSE, fcpB = FALSE)
}
\arguments{
\item{ysA}{A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{c} containing information about variable of interest from \eqn{s_A}.}

\item{ysB}{A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{c} containing information about variable of interest from \eqn{s_B}.}

\item{pi_A}{A numeric vector of length \eqn{n_A} or a square numeric matrix of dimension \eqn{n_A} containing first order or first and second order inclusion probabilities for units included in \eqn{s_A}.}

\item{pi_B}{A numeric vector of length \eqn{n_B} or a square numeric matrix of dimension \eqn{n_B} containing first order or first and second order inclusion probabilities for units included in \eqn{s_B}.}

\item{domains_A}{A character vector of size \eqn{n_A} indicating the domain each unit from \eqn{s_A} belongs to. Possible values are "a" and "ab".}

\item{domains_B}{A character vector of size \eqn{n_B} indicating the domain each unit from \eqn{s_B} belongs to. Possible values are "b" and "ba".}

\item{N_A}{(Optional) A numeric value indicating the size of frame A}

\item{N_B}{(Optional) A numeric value indicating the size of frame B}

\item{N_ab}{(Optional) A numeric value indicating the size of the overlap domain}

\item{XsAFrameA}{(Optional) A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{m_A}, with \eqn{m_A} the number of auxiliary variables in frame A, containing auxiliary information in frame A for units included in \eqn{s_A}.}

\item{XsBFrameA}{(Optional) A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{m_A}, with \eqn{m_A} the number of auxiliary variables in frame A, containing auxiliary information in frame A for units included in \eqn{s_B}. For units in domain \eqn{b}, these values are 0.}

\item{XsAFrameB}{(Optional) A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{m_B}, with \eqn{m_B} the number of auxiliary variables in frame B, containing auxiliary information in frame B for units included in \eqn{s_A}. For units in domain \eqn{a}, these values are 0.}

\item{XsBFrameB}{(Optional) A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{m_B}, with \eqn{m_B} the number of auxiliary variables in frame B, containing auxiliary information in frame B for units included in \eqn{s_B}.}

\item{XA}{(Optional) A numeric value or vector of length \eqn{m_A}, with \eqn{m_A} the number of auxiliary variables in frame A, indicating the population totals for the auxiliary variables considered in frame A.}

\item{XB}{(Optional) A numeric value or vector of length \eqn{m_B}, with \eqn{m_B} the number of auxiliary variables in frame B, indicating the population totals for the auxiliary variables considered in frame B.}

\item{conf_level}{A numeric value indicating the confidence level for the confidence intervals.}

\item{sdA}{(Optional) A character vector indicating the sampling design considered in frame A. Possible values are "srs" (simple random sampling), "pps" (probabilities proportional to size sampling) and "str" (stratified sampling). Default is "srs".}

\item{sdB}{(Optional) A character vector indicating the sampling design considered in frame B. Possible values are "srs" (simple random sampling), "pps" (probabilities proportional to size sampling) and "str" (stratified sampling). Default is "srs".}

\item{nhA}{(Optional) A numeric vector indicating the sample size in each stratum, if a stratified sample has been drawn in frame A.}

\item{nhB}{(Optional) A numeric vector indicating the sample size in each stratum, if a stratified sample has been drawn in frame B.}

\item{NhA}{(Optional) A numeric vector indicating the population size in each stratum, if a stratified sample has been drawn in frame A.}

\item{NhB}{(Optional) A numeric vector indicating the population size in each stratum, if a stratified sample has been drawn in frame B.}

\item{fcpA}{(Optional) A logic value indicating if a finite population correction factor should be considered in frame A. Default is FALSE}

\item{fcpB}{(Optional) A logic value indicating if a finite population correction factor should be considered in frame B. Default is FALSE}
}
\value{
A numeric matrix containing estimations of population total and population mean and their corresponding confidence intervals obtained through jackknife method.
}
\description{
Calculates confidence intervals for pseudo empirical likelihood estimator using jackknife procedure
}
\details{
Let suppose a non stratified sampling design in frame A and a stratified sampling design in frame B where frame has been divided into L strata and a sample of size \eqn{n_{Bl}} from the \eqn{N_{Bl}} composing the l-th stratum is selected
In this context, jackknife variance estimator of a estimator \eqn{\hat{Y}_c} is given by
 \deqn{v_J(\hat{Y}_c) = \frac{n_{A}-1}{n_{A}}\sum_{i\in s_A} (\hat{Y}_{c}^{A}(i) -\overline{Y}_{c}^{A})^2 + \sum_{l=1}^{L}\frac{n_{Bl}-1}{n_{Bl}}  \sum_{i\in s_{Bl}} (\hat{Y}_{c}^{B}(lj) -\overline{Y}_{c}^{Bl})^2}
with \eqn{\hat{Y}_c^A(i)} the value of estimator \eqn{\hat{Y}_c} after dropping \eqn{i-th} unit from \code{ysA} and \eqn{\overline{Y}_{c}^{A}} the mean of values \eqn{\hat{Y}_c^A(i)}.
Similarly, \eqn{\hat{Y}_c^B(lj)} is the value taken by \eqn{\hat{Y}_c} after dropping j-th unit of l-th from sample \code{ysB} and \eqn{\overline{Y}_{c}^{Bl}} is the mean of values \eqn{\hat{Y}_c^B(lj)}.
If needed, a finite population correction factor can be included in frames by replacing \eqn{\hat{Y}_{c}^{A}(i)} or \eqn{\hat{Y}_{c}^{B}(lj)} with \eqn{\hat{Y}_{c}^{A*}(i)= \hat{Y}_{c}+\sqrt{1-\overline{\pi}_A} (\hat{Y}_{c}^{A}(i) -\hat{Y}_{c})} or
\eqn{\hat{Y}_{c}^{B*}(lj)= \hat{Y}_{c}+\sqrt{1-\overline{\pi}_B} (\hat{Y}_{c}^{B}(lj) -\hat{Y}_{c})}, where \eqn{\overline{\pi}_A = \sum_{i \in s_A}\pi_{iA}/n_A} and \eqn{\overline{\pi}_B = \sum_{j \in s_B}\pi_{jB}/n_B}
A confidence interval for any parameter of interest, \eqn{Y} can be calculated, then, using the pivotal method.
}
\references{
Wolter, K. M. (2007)
 \emph{Introduction to Variance Estimation.}
 2nd Edition. Springer, Inc., New York.
}
\seealso{
\code{\link{PEL}}
}

