% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_species_ger_nfi_2012.R
\name{fe_species_ger_nfi_2012}
\alias{fe_species_ger_nfi_2012}
\title{Construct a \emph{fe_species_ger_nfi_2012} Species Code Vector}
\usage{
fe_species_ger_nfi_2012(x = character())
}
\arguments{
\item{x}{Input vector to become a vector of tree species codes by the
definition \emph{ger_nfi_2012}. Any type of vector (typically
\code{integer}) which, after conversion with \code{\link{as.character}},
adheres to that definition is acceptable. If \code{x} is provided as a
character vector, leading and trailing white spaces will be trimmed.}
}
\value{
If the user input allows to construct a well-defined
\code{fe_species_ger_nfi_2012} object, this object will be returned. If
not, the function will terminate with an error.
}
\description{
User interface for constructing a vector of species codes follwing the
\emph{fe_species_ger_nfi_2012} convention
}
\details{
The \emph{ger_nfi_2012} species coding is the species coding used by the German
National Forest Inventory of 2012. See the example section for how to look up
the coding.
}
\examples{
# Libraries required for the following two examples
library(dplyr)
library(purrr)

# Look up the ger_nfi_2012 species codes for all supported species
# the column species_id contains the ger_nfi_2012 codes
species_codings |>
  filter(species_coding == "ger_nfi_2012") |>
  pluck(2, 1) |>
  arrange(as.numeric(species_id)) |> # just for the look of it
  print(n = Inf)

# Display a summary table which shows the number of single species behind
# each ger_nfi_2012 species code
species_codings |>
  filter(species_coding == "ger_nfi_2012") |>
  pluck(2, 1) |>
  group_by(name_eng, species_id) |> # display english names
  summarise(n = n()) |>
  arrange(as.numeric(species_id)) |> # just for the look of it
  print(n = Inf)


# Make an fe_species_ger_nfi_2012 vector from a vector of integer codes
spec_ids <- fe_species_ger_nfi_2012(
  c(10, 10, 10, 100, 100, 100, 100, 20, 20, 190, 290, 190)
)

}
