% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stand_diameters_and_heights.R
\name{d_100}
\alias{d_100}
\title{Dominant Diameter d100}
\usage{
d_100(d, n_rep_ha)
}
\arguments{
\item{d}{vector of diameter values to calculate the dominant diameter d_100
of}

\item{n_rep_ha}{vector of representation numbers per ha for each diameter
in d. Must have the same length as d or the length 1 (in which case it is
recycled to the length of d). Otherwise, the function terminates with an
error.}
}
\value{
The dominant diameter d100 value resulting from the input data
}
\description{
The dominant diameter d100 was conceptuated by Ernst Assmann and Friedrich
Franz in order obtain a mean diameter value for those trees which usually
dominate a stand throughout its whole life.
}
\details{
The d100 is defined as the quadratic mean diameter of the hundred thickest
trees per ha. If there are only 100 trees or less on one ha, the d100 is the
same as the quadratic mean diameter \code{\link{d_q}}. While the d100 is well
defined and useful in monospecific stands, it is less so in mixed stands.
}
\examples{
# A sample of trees from an angle count sample, where each
# tree represents a basal area of 4 m²/ha
d_cm <- c(12, 13, 25, 27, 28, 26, 26.1, 32, 35, 31, 42)
n_rep_ha <- 4 / ((d_cm / 100)^2 * pi / 4) # representation number of each tree
d_100(d_cm, n_rep_ha)
d_q(d_cm, n_rep_ha) # quadratic mean diameter for comparison


# Typical application to a set of single tree data grouped by survey
# time and species
# (note that everyone is applying d_100 mixed stands, but you should do it
# only, if you know exactly what you are doing)
library(dplyr)
oldopt <- options(fe_spec_lang = "eng") # display colloquial species names
# for d_100 in mixed stands, we require species shares
spec_shares <- species_shares(
  mm_forest_1_fe_stand_spatial,
  tree_filter = !removal, # include remaining trees only
  method = "ba_wd"
)
# extract the tree data to allow insights into the mechanics
trees <- mm_forest_1_fe_stand_spatial$trees |> filter(!removal)
# join with the shares
trees |>
  left_join(spec_shares) |>
  group_by(species_id, time_yr) |>
  summarise(
    n_ha     = round(sum(n_rep_ha)),
    d_q      = d_q(dbh_cm, n_rep_ha), # For comparison
    d_100_cm = d_100(dbh_cm, n_rep_ha / species_share)
  ) |>
  print(n = Inf)
options(oldopt) # set species name display to previous value

}
\seealso{
Other stand diameters: 
\code{\link{d_dom_weise}()},
\code{\link{d_q}()}
}
\concept{stand diameters}
