% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.foreccomb_res.R
\name{summary.foreccomb_res}
\alias{print.foreccomb_res_summary}
\alias{summary.foreccomb_res}
\title{Summary of Forecast Combination}
\usage{
\method{summary}{foreccomb_res}(object, ...)

\method{print}{foreccomb_res_summary}(x, ...)
}
\arguments{
\item{object}{An object of class 'foreccomb'. Contains training set (actual values + matrix of model forecasts) and optionally a test set.}

\item{...}{potential further arguments (require by generic)}

\item{x}{An object of class 'foreccomb'. Contains training set (actual values + matrix of model forecasts) and optionally a test set.}
}
\description{
\code{summary} method for class \sQuote{foreccomb_res}. Includes information about combination method,
combination weights assigned to the individual forecast models, as well as an accuracy evaluation of the combined
forecast.
}
\examples{
obs <- rnorm(100)
preds <- matrix(rnorm(1000, 1), 100, 10)
train_o<-obs[1:80]
train_p<-preds[1:80,]
test_o<-obs[81:100]
test_p<-preds[81:100,]

data<-foreccomb(train_o, train_p, test_o, test_p)
fit<-comb_BG(data)
summary(fit)

}
\author{
Christoph E. Weiss and Gernot R. Roetzer
}
\seealso{
\code{\link[ForecastComb]{foreccomb}},
\code{\link[ForecastComb]{plot.foreccomb_res}},
}

