% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INFCaccuracyPlot.R
\name{PlottingINFCaccuracy}
\alias{PlottingINFCaccuracy}
\alias{INFCaccuracyPlot}
\alias{INFCaccuracyPlot0}
\alias{compute_grid0}
\title{Plotting the accuracy and reliability region (or 'domain') of the volume and
phytomass estimation functions}
\usage{
INFCaccuracyPlot(
  EPPOcod,
  quantity = "vol",
  ie.Var = FALSE,
  cv.ul = 0.1,
  fixed = TRUE,
  plot.est = FALSE,
  dbh.step = 5,
  htot.step = dbh.step,
  dbh.buf = 1,
  htot.buf = dbh.buf
)

INFCaccuracyPlot0(
  EPPOcod,
  quantity = "vol",
  ie.Var = FALSE,
  cv.ul = 0.1,
  fixed = TRUE,
  plot.est = FALSE
)

compute_grid0(pag, EPPOcod, quantity)
}
\arguments{
\item{EPPOcod}{A string, one of the EPPO tree species codes listed in
\code{INFCspecies} table (Reference: \url{https://gd.eppo.int} )}

\item{quantity}{(optional) A string specifying the quantity to be estimated,
one of \code{c("vol", "dw1" : "dw4")}.
Lookup \code{Qantities} table to retrieve codes definitions.
Defaults to "vol".}

\item{ie.Var}{(optional) Logical. Choose variance estimator:
\itemize{
\item \code{TRUE} = variance for an 'individual estimate'
\item \code{FALSE} = variance for the 'estimate of an average' value
Default \code{ie.Va = FALSE}}}

\item{cv.ul}{(optional) Numeric. Cutoff CV level for the plot. Defaults to 0.1}

\item{fixed}{(optional) Logical. Contour plot breaks:
\itemize{
\item \code{TRUE} = break levels are fixed
\item \code{FALSE} = breaks are tailored to the specific case
(in order to split the values within the range of interest [0, \code{cv.ul}],
into equally numerous bins)
Default \code{fixed = TRUE}}}

\item{plot.est}{(optional) Logical. Add the 'estimated quantity' layer as
contour lines. Default \code{plot.est = FALSE}}

\item{dbh.step}{(optional) Numeric. Computation with smaller step produces a
plot with better resolution but increases consistently computation time
(see \code{INFCaccuracyPlot0()}). To reduce computation time, the step
defaults to 5.}

\item{htot.step}{(optional) Numeric. As for dbh.}

\item{dbh.buf}{(optional) Numeric. Extra space in the plot beyond the 'domain'.
Default: 1}

\item{htot.buf}{(optional) Numeric. As for dbh.}

\item{pag}{for the internal function \code{compute_grid0()}}
}
\value{
\code{INFCaccuracyPlot} The function returns a ggplot object.
}
\description{
Volume and phytomass functions are tabulated in Tabacchi et al. (2011a).
The tabulation covers a limited region of the \code{dbh} by \code{h_tot} rectangle.
This region is the "domain" of the reliable estimates, based on the
distribution of the sample trees used to calibrate the functions.
The coefficient of variation (CV = standard_deviation / estimate) is computed
and plotted (as 'filled contours') for the whole rectangular area,
the limits of the region of reliable estimates (the "domain"), is
superimposed as a light colored line. Function output is a \code{ggplot} object that can be used
by its self or as a background on top of which the user can plot his/her data to
verify eventual accuracy or reliability problems.\cr
Two functions are available.
\itemize{
\item \code{INFCaccuracyPlot()} - allows the plots to be fully customized but, beware,
all values required for the 'fill' will be computed and,
at finer resolution, the process can be slow.
\item \code{INFCaccuracyPlot0()} - produces, much faster, the plots at the finest
resolution, using pre-calculated values stored in
a specific auxiliary dataframe (see \code{\link{INFC_CVgrid}}),
necessarily leaving less customization freedom.
}
(** \code{compute_grid0()} - is an internal function exported for the sake of
the \code{Populate_INFC_CVgrid()} function **)
}
\examples{
\dontrun{
INFCaccuracyPlot("FRXAN") # 'INFCaccuracyPlot()' can be slow because
#       it computes all the CV values needed to fill backgroud plot,
#              hence default values are set to a coarser resolution.
\donttest{
  INFCaccuracyPlot("FRXAN",
                   dbh.step = 1,
                   htot.step = 1) 
  # computing with high resolution is slow
}

INFCaccuracyPlot0("FRXAN") 
# 'INFCaccuracyPlot0()' is quick, it uses stored values
INFCaccuracyPlot0("FRXAN", "dw4")
INFCaccuracyPlot0("FRXAN", "dw4", ie.Var = TRUE) 
# deafult fixed break values are not alwais optimal
INFCaccuracyPlot0("FRXAN", "dw4", ie.Var = TRUE, fixed = FALSE, cv.ul=.9) 
# tailoring can improve
INFCaccuracyPlot0("FRXAN", plot.est = TRUE) 
# 'quantity' estimation iso-lines can be superimposed


background <- INFCaccuracyPlot0("ACROP", plot.est = TRUE)
foreground <-  ForIT_test_data \%>\%
  dplyr::filter(specie == "ACROP") \%>\%
  dplyr::mutate(vol = INFCvpe(specie, d130, h_dendro)) \%>\%
  ggplot2::geom_point(map = ggplot2::aes(h_dendro, d130, size = vol))
background + foreground  # Adding a custom foreground
rm(background, foreground)

INFCaccuracyPlot0("ABIAL") 
# high resolution and quick, using pre-calculated backgroung values
INFCaccuracyPlot("ABIAL") 
# default values produce a coarser resolution
}
}
