% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/station.info.R
\name{station.info}
\alias{station.info}
\title{Retrieve Station Info}
\usage{
station.info(Agency, StationID, Plot = FALSE, Language = "English")
}
\arguments{
\item{Agency}{String indicating Agency where streamflow data.}

\item{StationID}{String of the Station ID}

\item{Plot}{Boolean indicating whether a plot of station information should be created.
Default is FALSE. Plot is intended for use as the upper-left panel of the plot produced 
by \code{\link{screen.summary}}.}

\item{Language}{Language for plotting when Plot = T.  Choice of either "English" or
"French". Default is "English".}
}
\value{
Returns a data.frame of the following station information:
  \itemize{
    \item $Agency - Name of Agency from which the record came
    \item $StationID
    \item $StnName
    \item $StateProv - State, Province, or Territory where the station is located
    \item $Country - Country in which the station is located
    \item $Lat - Latitude of the station, numeric
    \item $Lon - Longitude of the station, numeric
    \item $CatchmentArea_km2 - total drainage area in square kilometers
    \item $RHN - Indication whether the station is part of a reference hydrologic network, TRUE/FALSE
    \item $MetadataSource - Indication of where the metadata came from, e.g. WSC Hydat, USGS, user-supplied.
    \item $StationID_Alternate - Alternate station ID, e.g. original station ID versus ROBIN database
  }
}
\description{
Returns station information from metadata included in the package data files. If
there is no metadata match for the StationID AND Agency, returns NA values for all other columns.
}
\examples{
data(cania.sub.ts)
stn_metdat <- station.info(cania.sub.ts$Agency[1], cania.sub.ts$ID[1])
print(stn_metdat)
}
\author{
Jennifer Dierauer
}
