### Generate pie chart pictures
library(ggplot2)
library(ggforce)
library(rsvg)

picture_number=100

for (i in 1:picture_number){
  # Generate pie chart
  p <- ggplot() + geom_arc_bar(aes(x0 = 0.5, y0 = 0.5, r0 = 0, r = 0.5, start = 0,
                        end = i*2*pi/picture_number)) + xlim(0,1) + ylim(0,1) + theme_void()
  
  # Change file name if i<10
  i_name=ifelse(i<10, paste("0",i,sep=""), i)
  file_name=paste("pie_chart_opening_",i_name,"_of_",picture_number,".svg", sep="")
  
  # Save pie chart
  ggsave(filename = file_name, plot = p, device = "svg",width = 1, height = 1, bg="transparent")
  
  # Convert SVG file to grImport2 compatibility (has to be generated by Cairo graphics)
  rsvg_svg(file_name, file_name)
}


