% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pyroscience.aquaresp.R
\name{pyroscience.aquaresp}
\alias{pyroscience.aquaresp}
\title{Convert respirometry data from PyroScience and AquaResp software to the FishResp format}
\usage{
pyroscience.aquaresp(pyroscience.file,
                     aquaresp.file,
                     fishresp.file,
                     n.chamber = c(1,2,3,4),
                     date.format = c("DMY", "MDY", "YMD"),
                     wait.phase = NA, measure.phase = NA)
}
\arguments{
\item{pyroscience.file}{the name of a file which contains raw data obtained from the 'Pyro Oxygen Logger' software (PyroScience, <https://www.pyro-science.com>)}

\item{aquaresp.file}{the name of a file which contains summary data obtained from the 'AquaResp' software (<www.aquaresp.com>)}

\item{fishresp.file}{the name of an exported file containing raw data in the FishResp format}

\item{n.chamber}{integer: the number of chambers used in an experiment (including empty ones)}

\item{date.format}{string: date format (DMY, MDY or YMD) used in raw data obtained from the 'Pyro Oxygen Logger' software}

\item{wait.phase}{integer: duration of the wait phase (in seconds), see the AquaResp summary file (row #5)}

\item{measure.phase}{integer: duration of the measure phase (in seconds), see the AquaResp summary file (row #6)}
}
\value{
the function exports a file containing raw data in the FishResp format
}
\description{
The function is used to convert raw data from 'Pyro Oxygen Logger' (PyroScience, <https://www.pyro-science.com>) and a summary file from 'AquaResp' (<www.aquaresp.com>) to FishResp format. This function should be applied before usage of the functions \code{\link{import.test}} and \code{\link{import.meas}}. The output is a file containing raw respirometry data in the FishResp format (see Details in \code{\link{import.test}} to read more information about the FishResp format)
}
\examples{

pyroscience.path = system.file("extdata/pyroscience/pyroscience.txt",
                 package = "FishResp")
aquaresp.path = system.file("extdata/pyroscience/pyroscience-aquaresp.txt",
                 package = "FishResp")

pyroscience.aquaresp(pyroscience.file = pyroscience.path,
                     aquaresp.file = aquaresp.path,
                     fishresp.file = "fishresp.txt",
                     date.format = "MDY",
                     n.chamber = 1,
                     wait.phase = 120,
                     measure.phase = 600)

}
