#' @title phi_psi_plot
#'
#' @description Function to plot a PDB file phi/psi angle density plot
#'
#' @param pdb_df Requires a PDB data frame generated by PDB_prepare
#' @return  2D phi/psi angle distribution plot with residues binned
#' @ImportFrom ggplot2 aes
#' @ImportFrom ggplot2 ggplot
#' @ImportFrom ggplot2 geom_hex
#' @ImportFrom ggplot2 scale_x_continuous
#' @ImportFrom ggplot2 scale_y_continuous
#' @ImportFrom ggplot2 labs
#' @ImportFrom ggplot2 ggtitle
#' @ImportFrom ggplot2 theme_bw
#' @export
#' @examples
#' path_to_processed_PDB<- system.file("extdata", "pdb_df.tabular", package="Fiscore")
#' # basic usage of phi_psi_plot
#' pdb_df<-read.table(path_to_processed_PDB)
#' phi_psi_plot(pdb_df)
phi_psi_plot<-function(pdb_df){

  #to avoid namespace conflucts
  phi_val<-pdb_df$"phi"
  psi_val<-pdb_df$"psi"

  ggplot2::ggplot(data=pdb_df)+ggplot2::geom_hex(ggplot2::aes(x=phi_val, y =psi_val))+ggplot2::scale_x_continuous(breaks=c(-180,-120,-60,0,60,120,180),limits = c(-180, 180), expand = c(0,0)) +ggplot2::scale_y_continuous(breaks=c(-180,-120,-60,0,60,120,180),limits = c(-180,180), expand = c(0,0))+ggplot2::labs(x="phi",y="psi")+ ggplot2::theme_bw()






}
