% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_effects.R
\name{theoretical_variogram}
\alias{theoretical_variogram}
\title{Theoretical variogram}
\usage{
theoretical_variogram(
  n_cols,
  n_rows,
  var_R = 1,
  prop_spatial = 0.5,
  col_cor,
  row_cor
)
}
\arguments{
\item{n_cols}{A scalar defining the number of columns.}

\item{n_rows}{A scalar defining the number of rows.}

\item{var_R}{A scalar defining the total error variance.}

\item{prop_spatial}{A scalar defining the proportion of spatial error variance to total error
variance (spatial + random).}

\item{col_cor}{A scalar defining the column autocorrelation value.}

\item{row_cor}{A scalar defining the row autocorrelation value.}
}
\value{
Graphic of the theoretical variogram, where the x- and y- axes display the row and
  column displacements and the z-axis displays the semi-variance (variogram ordinates).
}
\description{
Creates a theoretical variogram. The x- and y-axes display the row and column displacements,
respectively. The z-axis displays the semi-variance (variogram ordinates).
}
\examples{
# Theoretical variogram for a field with 10 columns and 20 rows, using column and row
# autocorrelations of 0.4 and 0.8.

vario <- theoretical_variogram(
  n_cols = 10,
  n_rows = 20,
  var_R = 1,
  prop_spatial = 0.5,
  col_cor = 0.4,
  row_cor = 0.8
)

# Theoretical variogram
vario

# Extraction of a data frame containing the column and row displacements as well as the
# semi-variances (theoretical variogram ordinates).

theoretical_df <- vario$data

}
