% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unstructured_gxe.R
\name{unstr_asr_input}
\alias{unstr_asr_input}
\title{Genetic values based on an unstructured model for GxE interaction using 'AlphaSimR' - Input
parameters}
\usage{
unstr_asr_input(
  n_envs,
  n_traits,
  mean,
  var = NULL,
  T_var = NULL,
  E_var = NULL,
  cor_A = NULL,
  E_cor_A = NULL,
  T_cor_A = NULL,
  mean_DD = NULL,
  var_DD = NULL,
  E_var_DD = NULL,
  T_var_DD = NULL,
  cor_DD = NULL,
  E_cor_DD = NULL,
  T_cor_DD = NULL,
  rel_AA = NULL,
  E_rel_AA = NULL,
  T_rel_AA = NULL,
  cor_AA = NULL,
  E_cor_AA = NULL,
  T_cor_AA = NULL
)
}
\arguments{
\item{n_envs}{Number of environments to be simulated. A minimum of two environments is required.}

\item{n_traits}{Number of traits to be simulated.}

\item{mean}{A vector of mean genetic values for each trait-by-environment combination (ordered
as environments within traits). Simulated traits can have a different mean for each
environment. If the length of \code{mean} corresponds to \code{n_traits}, all traits will be
assigned the same mean for each environment.}

\item{var}{A vector of genetic variances for each trait-by-environment combination (ordered as
environments within traits). If the length of \code{var} is equal to \code{n_traits}, all
traits will be assigned the same error variance in each environment. \cr
Alternatively, if a separable structure between traits and environments is desired,
\code{T_var} and \code{E_var} can be provided. By default, \code{var = NULL}.}

\item{T_var}{A vector of genetic variances for each trait. Must be provided in combination with
\code{E_var}. \cr
Alternatively, \code{var} can be provided. By default, \code{T_var = NULL}.}

\item{E_var}{A vector of genetic variances for each environment. Must be provided in
combination with \code{T_var}. \cr
Alternatively, \code{var} can be provided. By default, \code{E_var = NULL}.}

\item{cor_A}{A matrix of additive genetic correlations between all trait-by-environment
combinations. If not defined and \code{n_traits > 1}, a diagonal matrix is constructed. \cr
Alternatively, \code{T_cor_A} and \code{E_cor_A} can be provided.}

\item{E_cor_A}{A matrix of additive genetic correlations between more than one environment.
Must be provided in combination with \code{T_cor_A}. \cr
Alternatively, \code{cor_A} can be provided. By default, \code{E_cor_A = NULL}.}

\item{T_cor_A}{A matrix of additive genetic correlations between more than one trait. Must be
provided in combination with \code{E_cor_A}. \cr
Alternatively, \code{cor_A} can be provided. By default, \code{T_cor_A = NULL}.}

\item{mean_DD}{A vector of mean dominance degrees for each trait-by-environment combination
(ordered as environments within traits), similar to \code{mean}. By default,
\code{mean_DD = NULL} and dominance is not simulated.}

\item{var_DD}{A vector of dominance degree variances for each trait-by-environment combination
(ordered as environments within traits), similar to \code{var}. \cr
Alternatively, if a separable structure between traits and environments is desired,
\code{T_var_DD} and \code{E_var_DD} can be provided. By default, \code{var_DD = NULL}.}

\item{E_var_DD}{A vector of dominance degree genetic variances for each environment, similar to
\code{E_var}. Must be provided in combination with \code{T_var_DD}. \cr
Alternatively, \code{var_DD} can be provided. By default, \code{E_var_DD = NULL}.}

\item{T_var_DD}{A vector of dominance degree variances for each trait, similar to \code{T_var}.
Must be provided in combination with \code{E_var_DD}. \cr
Alternatively, \code{var_DD} can be provided. By default, \code{T_var_DD = NULL}.}

\item{cor_DD}{A matrix of dominance degree correlations between all trait-by-environment
combinations, similar to \code{cor_A}. If not defined and \code{n_traits > 1}, a diagonal
matrix is constructed. \cr
Alternatively, \code{T_cor_DD} and \code{E_cor_DD} can be provided. By default,
\code{cor_DD = NULL}.}

\item{E_cor_DD}{A matrix of dominance degree correlations between more than one environment,
similar to \code{E_cor_A}. Must be provided in combination with \code{T_cor_DD}. \cr
Alternatively, \code{cor_DD} can be provided. By default, \code{E_cor_DD = NULL}.}

\item{T_cor_DD}{A matrix of dominance degree correlations between more than one trait, similar
to \code{T_cor_A}. Must be provided in combination with \code{E_cor_DD}. \cr
Alternatively, \code{cor_DD} can be provided. By default, \code{T_cor_DD = NULL}.}

\item{rel_AA}{A vector defining the magnitude of additive-by-additive (epistatic) variance
relative to additive genetic variance for each trait-by-environment combination (ordered as
environments within traits), that is in a diploid organism with allele frequency 0.5. \cr
Alternatively, if a separable structure between traits and environments is desired,
\code{T_rel_AA} and \code{E_rel_AA} can be provided. By default, \code{rel_AA = NULL} and
epistasis is not simulated.}

\item{E_rel_AA}{A vector defining the magnitude of additive-by-additive (epistatic) variance
relative to the additive genetic variance for each environment, that is in a diploid organism
with allele frequency 0.5. Must be provided in combination with \code{T_rel_AA}. \cr
Alternatively, \code{rel_AA} can be provided. By default, \code{E_rel_AA = NULL}.}

\item{T_rel_AA}{A vector defining the magnitude of additive-by-additive (epistatic) variance
relative to the additive genetic variance for each trait, that is in a diploid organism with
allele frequency 0.5. Must be provided in combination with \code{E_rel_AA}. \cr
Alternatively, \code{rel_AA} can be provided. By default, \code{T_rel_AA = NULL}.}

\item{cor_AA}{A matrix of epistatic correlations between all trait-by-environment
combinations, similar to \code{cor_A}. If not defined and \code{n_traits > 1},
a diagonal matrix is constructed. \cr
Alternatively, \code{T_cor_AA} and \code{E_cor_AA} can be provided. By default,
\code{cor_AA = NULL}.}

\item{E_cor_AA}{A matrix of epistatic correlations between more than one environment, similar
to \code{E_cor_A}. Must be provided in combination with \code{T_cor_AA}. \cr
Alternatively, \code{cor_AA} can be provided. By default, \code{E_cor_AA = NULL}.}

\item{T_cor_AA}{A matrix of epistatic correlations between more than one trait, similar to
\code{T_cor_A}. Must be provided in combination with \code{E_cor_AA}. \cr
Alternatively, \code{cor_AA} can be provided. By default, \code{T_cor_AA = NULL}.}
}
\value{
A list containing input parameters for 'AlphaSimR', which is used to simulate
  correlated genetic effects based on an unstructured model.
}
\description{
Creates a list of simulation parameters for
\href{https://CRAN.R-project.org/package=AlphaSimR}{'AlphaSimR'} to simulate
genetic values for multiple traits in multiple environments based on an unstructured model for
genotype-by-environment (GxE) interaction. \cr
By default, 'AlphaSimR' does not support complex models for GxE interaction. However, its
functionality to simulate correlated genetic values can be utilised for this purpose by
providing the required variance structures. \code{unstr_asr_input} is a wrapper function to
construct the variance structures required to simulate GxE interaction in 'AlphaSimR' based on
an unstructured model. This function is also used in combination with the
wrapper function \link[FieldSimR]{compsym_asr_output}.
}
\details{
\code{unstr_asr_input} can handle non-separable and separable structures between traits and
environments.
\itemize{
  \item For non-separable structures, provide (1) \code{var}, and (2) \code{cor_A}.
  \item For separable structures, provide (1) \code{T_var} & \code{E_var}, and (2)
  \code{T_cor_A} & \code{E_cor_A}. \cr
  }

\strong{Note:} 'AlphaSimR' can simulate different biological effects (see:
\code{\link[AlphaSimR]{SimParam}}).
\itemize{
  \item For additive traits use \code{addTraitA()}.
  \item For additive + dominance traits use \code{addTraitAD()}.
  \item For additive + epistatic traits use \code{addTraitAE()}.
  \item For additive + dominance + epistatic traits use \code{addTraitADE()}.
  }
If non-additive effects are to be simulated, check the \code{useVarA} argument of these
functions.
}
\examples{
# Simulation of genetic values in 'AlphaSimR' for two additive + dominance traits tested in
# three environments based on an unstructured model for GxE interaction.

# 1. Define the genetic architecture of the simulated traits.
# Mean genetic values and mean dominance degrees for trait 1 in all 3 environments and trait 2
# in all 3 environments.
mean <- c(1, 3, 2, 80, 70, 100) # Trait 1 x 3 environments, trait 2 x 3 environments.
mean_DD <- c(0.1, 0.4) # Trait 1 and 2, same values set in all 3 environments for each trait.

# Additive genetic variances (useVarA = TRUE) and dominance degree variances for traits 1 and 2,
# assuming a separable structure between traits and environments.
T_var <- c(0.2, 10) # Genetic variances defined for the two traits.
E_var <- c(0.5, 1, 1.5) # Genetic variances defined for the three environments.

# Dominance degree variances for trait 1 in 3 environments and for trait 2 in 3 environments,
# assuming a non-separable structure between traits and environments.
var_DD <- c(0.1, 0.15, 0.2, 0.2, 0.3, 0.2)

# Additive genetic correlations between the two simulated traits.
T_cor_A <- matrix(c(
  1.0, 0.3,
  0.3, 1.0
),
ncol = 2
)

# Additive genetic correlations between the three simulated environments.
E_cor_A <- stats::cov2cor(matrix(c(
  0.5, 0.4, 0.6,
  0.4, 1.0, 0.5,
  0.6, 0.5, 1.5
),
ncol = 3
))

# Dominance degree correlation between all six trait-by-environment combinations.
cor_DD <- diag(6) # Assuming independence between traits

input_asr <- unstr_asr_input(
  n_envs = 3,
  n_traits = 2,
  mean = mean,
  T_var = T_var,
  E_var = E_var,
  T_cor_A = T_cor_A,
  E_cor_A = E_cor_A,
  mean_DD = mean_DD,
  var_DD = var_DD,
  cor_DD = cor_DD
)
}
