% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_CRD.R
\name{CRD}
\alias{CRD}
\title{Generates a Completely Randomized Design (CRD)}
\usage{
CRD(
  t = NULL,
  reps = NULL,
  plotNumber = 101,
  locationName = NULL,
  seed = NULL,
  data = NULL
)
}
\arguments{
\item{t}{An integer number with total number of treatments or a vector of dimension t with labels.}

\item{reps}{Number of replicates of each treatment.}

\item{plotNumber}{Starting plot number. By default \code{plotNumber = 101}.}

\item{locationName}{(optional) Name of the location.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{data}{(optional) Data frame with the 2 columns with labels of each treatments and its number of replicates.}
}
\value{
A list with two elements.
\itemize{
  \item \code{infoDesign} is a list with information on the design parameters.
  \item \code{fieldBook} is a data frame with the CRD field book.
}
}
\description{
It randomly generates a completely randomized design.
}
\examples{
# Example 1: Generates a CRD design with 10 treatments and 5 reps each.
crd1 <- CRD(t = 10,
            reps = 5,
            plotNumber = 101,
            seed = 1987,
            locationName = "Fargo")
crd1$infoDesign
head(crd1$fieldBook,10)

# Example 2: Generates a CRD design with 15 treatments and 6 reps each.
Gens <- paste("Wheat", 1:15, sep = "")
crd2 <- CRD(t = Gens,
            reps = 6,
            plotNumber = 1001,
            seed = 1654,
            locationName = "Fargo")
crd2$infoDesign
head(crd2$fieldBook,10)

# Example 3: Generates a CRD design with 12 treatments and 4 reps each.
# In this case, we show how to use the option data.
treatments <- paste("ND-", 1:12, sep = "")
treatment_list <- data.frame(list(TREATMENT = treatments, REP = 4))
head(treatment_list)
crd3 <- CRD(t = NULL,
            reps = NULL,
            plotNumber = 2001,
            seed = 1655,
            locationName = "Cali",
            data = treatment_list)
crd3$infoDesign
head(crd3$fieldBook,10)

}
\references{
Federer, W. T. (1955). Experimental Design. Theory and Application. New York, USA. The
Macmillan Company.
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb],
        Thomas Walk [ctb], 
        Johan Aparicio [ctb], 
        Richard Horsley [ctb]
}
