% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_split_plot.R
\name{split_plot}
\alias{split_plot}
\title{Generates a Split Plot Design}
\usage{
split_plot(
  wp = NULL,
  sp = NULL,
  reps = NULL,
  type = 2,
  l = 1,
  plotNumber = 101,
  seed = NULL,
  locationNames = NULL,
  factorLabels = TRUE,
  data = NULL
)
}
\arguments{
\item{wp}{Number of whole plots, as an integer or a vector.}

\item{sp}{Number of sub plots per whole plot, as an integer or a vector.}

\item{reps}{Number of blocks (full replicates).}

\item{type}{Option for CRD or RCBD designs. Values are \code{type = 1} (CRD) or \code{type = 2} (RCBD). By default \code{type = 2}.}

\item{l}{Number of locations. By default \code{l = 1}.}

\item{plotNumber}{Numeric vector with the starting plot number for each location. By default \code{plotNumber = 101}.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{locationNames}{(optional) Names for each location.}

\item{factorLabels}{(optional) If \code{TRUE} retain the levels
labels from the original data set otherwise, numeric labels will be
assigned. Default is \code{factorLabels =TRUE}.}

\item{data}{(optional) Data frame with label list of treatments.}
}
\value{
A list with two elements.
\itemize{
  \item \code{infoDesign} is a list with information on the design parameters.
  \item \code{fieldBook} is a data frame with the split plot field book.
}
}
\description{
It randomly generates a split plot design (SPD) across locations.
}
\examples{
# Example 1: Generates a split plot design SPD with 4 whole plots, 2 sub plots per whole plot,
# and 4 reps in an RCBD arrangement. This in for a single location.
SPDExample1 <- split_plot(wp = 4, sp = 2, reps = 5, l = 1, 
                          plotNumber = 101, 
                          seed = 14,
                          type = 2, 
                          locationNames = "FARGO")
SPDExample1$infoDesign
SPDExample1$layoutlocations
head(SPDExample1$fieldBook,12)

# Example 2: Generates a split plot design SPD with 5 whole plots 
# (4 types of fungicide + one control), 10 sub plots per whole plot (10 bean varieties), 
# and 6 reps in an RCBD arrangement. This in 3 locations or sites.
# In this case, we show how to use the option data.
wp <- c("NFung", paste("Fung", 1:4, sep = ""))  # Fungicides (5 Whole plots)
sp <- paste("Beans", 1:10, sep = "")            # Beans varieties (10 sub plots)
split_plot_Data <- data.frame(list(WHOLPLOT = c(wp, rep(NA, 5)), SUBPLOT = sp))
head(split_plot_Data, 12)
SPDExample2 <- split_plot(reps = 6, l = 3, 
                          plotNumber = c(101, 1001, 2001),
                          seed = 23, 
                          type = 2, 
                          locationNames = c("A", "B", "C"),
                          data = split_plot_Data)
SPDExample2$infoDesign
SPDExample2$layoutlocations
head(SPDExample2$fieldBook,12)
             
                  
}
\references{
Federer, W. T. (1955). Experimental Design. Theory and Application. New York, USA. The
Macmillan Company.
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb],
        Thomas Walk [ctb], 
        Johan Aparicio [ctb], 
        Richard Horsley [ctb]
}
