% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_row_column.R
\name{row_column}
\alias{row_column}
\title{Generates a Resolvable Row-Column Design (RowColD)}
\usage{
row_column(
  t = NULL,
  nrows = NULL,
  r = NULL,
  l = 1,
  plotNumber = 101,
  locationNames = NULL,
  seed = NULL,
  data = NULL
)
}
\arguments{
\item{t}{Number of  treatments.}

\item{nrows}{Number of rows of a full resolvable replicate.}

\item{r}{Number of blocks (full resolvable replicates).}

\item{l}{Number of locations. By default \code{l = 1}.}

\item{plotNumber}{Numeric vector with the starting plot number for each location. By default \code{plotNumber = 101}.}

\item{locationNames}{(optional) Names for each location.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{data}{(optional) Data frame with label list of treatments}
}
\value{
A list with four elements.
\itemize{
  \item \code{infoDesign} is a list with information on the design parameters.
  \item \code{resolvableBlocks} a list with the resolvable row columns blocks. 
  \item \code{concurrence} is the concurrence matrix.
  \item \code{fieldBook} is a data frame with the row-column field book.
}
}
\description{
It randomly generates a resolvable row-column designs (RowColD). 
Note that design optimization is only done at the level of rows and not columns; 
hence, design is suboptimal. The randomization can be done across locations.
}
\examples{

# Example 1: Generates a row-column design with 3 full blocks and 36 treatments
# and 6 rows. This for one location.
rowcold1 <- row_column(t = 36, nrows = 6, r = 3, l = 1, 
                       plotNumber= 101, 
                       locationNames = "Loc1",
                       seed = 21)
rowcold1$infoDesign
rowcold1$resolvableBlocks
head(rowcold1$fieldBook,12)

# Example 2: Generates a row-column design with 3 full blocks and 30 treatments
# and 5 rows, for two locations.
# In this case, we show how to use the option data.
treatments <- paste("ND-", 1:30, sep = "")
ENTRY <- 1:30
treatment_list <- data.frame(list(ENTRY = ENTRY, TREATMENT = treatments))
head(treatment_list)
rowcold2 <- row_column(t = 30, nrows = 5, r = 3, l = 2, 
                       plotNumber= c(101,1001), 
                       locationNames = c("A", "B"),
                       seed = 15,
                       data = treatment_list)
rowcold2$infoDesign
rowcold2$resolvableBlocks
head(rowcold2$fieldBook,12)
  

}
\references{
Edmondson., R. N. (2021). blocksdesign: Nested and crossed block designs for factorial and
unstructured treatment sets. https://CRAN.R-project.org/package=blocksdesign
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb],
        Thomas Walk [ctb], 
        Johan Aparicio [ctb], 
        Richard Horsley [ctb]
}
