% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DetailedCovariateSettings.R
\name{createAnalysisDetails}
\alias{createAnalysisDetails}
\title{Create detailed covariate settings}
\usage{
createAnalysisDetails(
  analysisId,
  sqlFileName,
  parameters,
  includedCovariateConceptIds = c(),
  addDescendantsToInclude = FALSE,
  excludedCovariateConceptIds = c(),
  addDescendantsToExclude = FALSE,
  includedCovariateIds = c()
)
}
\arguments{
\item{analysisId}{An integer between 0 and 999 that uniquely identifies this
analysis.}

\item{sqlFileName}{The name of the parameterized SQL file embedded in the
\code{featureExtraction} package.}

\item{parameters}{The list of parameter values used to render the template SQL.}

\item{includedCovariateConceptIds}{A list of concept IDs that should be used to construct
covariates.}

\item{addDescendantsToInclude}{Should descendant concept IDs be added to the list of concepts
to include?}

\item{excludedCovariateConceptIds}{A list of concept IDs that should NOT be used to construct
covariates.}

\item{addDescendantsToExclude}{Should descendant concept IDs be added to the list of concepts
to exclude?}

\item{includedCovariateIds}{A list of covariate IDs that should be restricted to.}
}
\value{
An object of type \code{analysisDetail}, to be used in
\code{\link{createDetailedCovariateSettings}} or
\code{\link{createDetailedTemporalCovariateSettings}}.
}
\description{
Create detailed covariate settings
}
\details{
creates an object specifying in detail how covariates should be constructed from data in the CDM
model. Warning: this function is for advanced users only.
}
\examples{
analysisDetails <- createAnalysisDetails(
  analysisId = 1,
  sqlFileName = "DemographicsGender.sql",
  parameters = list(
    analysisId = 1,
    analysisName = "Gender",
    domainId = "Demographics"
  ),
  includedCovariateConceptIds = c(),
  addDescendantsToInclude = FALSE,
  excludedCovariateConceptIds = c(),
  addDescendantsToExclude = FALSE,
  includedCovariateIds = c()
)

}
