# Copyright 2024 Observational Health Data Sciences and Informatics
#
# This file is part of FeatureExtraction
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This file has been autogenerated. Do not change by hand.

#' Create covariate settings
#'
#' @details
#' creates an object specifying how covariates should be constructed from data in the CDM model.
#'
#' @param useDemographicsGender                    Gender of the subject. (analysis ID 1)
#' @param useDemographicsAge                       Age of the subject on the index date (in years).
#'                                                 (analysis ID 2)
#' @param useDemographicsAgeGroup                  Age of the subject on the index date (in 5 year age
#'                                                 groups) (analysis ID 3)
#' @param useDemographicsRace                      Race of the subject. (analysis ID 4)
#' @param useDemographicsEthnicity                 Ethnicity of the subject. (analysis ID 5)
#' @param useDemographicsIndexYear                 Year of the index date. (analysis ID 6)
#' @param useDemographicsIndexMonth                Month of the index date. (analysis ID 7)
#' @param useConditionOccurrence                   One covariate per condition in the
#'                                                 condition_occurrence table starting in the time
#'                                                 window. (analysis ID 101)
#' @param useConditionOccurrencePrimaryInpatient   One covariate per condition observed as a primary
#'                                                 diagnosis in an inpatient setting in the
#'                                                 condition_occurrence table starting in the time
#'                                                 window. (analysis ID 102)
#' @param useConditionEraStart                     One covariate per condition in the condition_era
#'                                                 table starting in the time window. (analysis ID 201)
#' @param useConditionEraGroupStart                One covariate per condition era rolled up to SNOMED
#'                                                 groups in the condition_era table starting in the
#'                                                 time window. (analysis ID 203)
#' @param useDrugExposure                          One covariate per drug in the drug_exposure table
#'                                                 starting in the time window. (analysis ID 301)
#' @param useDrugEraStart                          One covariate per drug in the drug_era table
#'                                                 starting in the time window. (analysis ID 401)
#' @param useDrugEraGroupStart                     One covariate per drug rolled up to ATC groups in
#'                                                 the drug_era table starting in the time window.
#'                                                 (analysis ID 403)
#' @param useProcedureOccurrence                   One covariate per procedure in the
#'                                                 procedure_occurrence table in the time window.
#'                                                 (analysis ID 501)
#' @param useDeviceExposure                        One covariate per device in the device exposure
#'                                                 table starting in the timewindow. (analysis ID 601)
#' @param useMeasurement                           One covariate per measurement in the measurement
#'                                                 table in the time window. (analysis ID 701)
#' @param useMeasurementValue                      One covariate containing the value per
#'                                                 measurement-unit combination in the time window. If
#'                                                 multiple values are found, the last is taken.
#'                                                 (analysis ID 702)
#' @param useObservation                           One covariate per observation in the observation
#'                                                 table in the time window. (analysis ID 801)
#' @param timePart                                The interval scale ('DAY', 'MONTH', 'YEAR')
#' @param timeInterval                            Fixed interval length for timeId using the 'timePart' scale.  For example, a 'timePart' of DAY with
#'                                                 'timeInterval' 30 has timeIds where timeId 1 is day 0 to day 29, timeId 2 is day 30 to day 59, etc.
#' @param sequenceEndDay                                  What is the end day (relative to the
#'                                                 index date) of the data extraction?
#' @param sequenceStartDay                                What is the start day (relative to the
#'                                                 index date) of the data extraction?
#' @param includedCovariateConceptIds              A list of concept IDs that should be used to
#'                                                 construct covariates.
#' @param addDescendantsToInclude                  Should descendant concept IDs be added to the list
#'                                                 of concepts to include?
#' @param excludedCovariateConceptIds              A list of concept IDs that should NOT be used to
#'                                                 construct covariates.
#' @param addDescendantsToExclude                  Should descendant concept IDs be added to the list
#'                                                 of concepts to exclude?
#' @param includedCovariateIds                     A list of covariate IDs that should be restricted
#'                                                 to.
#'
#' @return
#' An object of type \code{covariateSettings}, to be used in other functions.
#'
#' @examples
#' settings <- createTemporalSequenceCovariateSettings(
#'   useDemographicsGender = TRUE,
#'   useDemographicsAge = FALSE,
#'   useDemographicsAgeGroup = TRUE,
#'   useDemographicsRace = TRUE,
#'   useDemographicsEthnicity = TRUE,
#'   useDemographicsIndexYear = TRUE,
#'   useDemographicsIndexMonth = TRUE,
#'   useConditionOccurrence = FALSE,
#'   useConditionOccurrencePrimaryInpatient = FALSE,
#'   useConditionEraStart = FALSE,
#'   useConditionEraGroupStart = FALSE,
#'   useDrugExposure = FALSE,
#'   useDrugEraStart = FALSE,
#'   useDrugEraGroupStart = FALSE,
#'   useProcedureOccurrence = TRUE,
#'   useDeviceExposure = TRUE,
#'   useMeasurement = TRUE,
#'   useMeasurementValue = FALSE,
#'   useObservation = TRUE,
#'   timePart = "DAY",
#'   timeInterval = 1,
#'   sequenceEndDay = -1,
#'   sequenceStartDay = -730,
#'   includedCovariateConceptIds = c(),
#'   addDescendantsToInclude = FALSE,
#'   excludedCovariateConceptIds = c(),
#'   addDescendantsToExclude = FALSE,
#'   includedCovariateIds = c()
#' )
#'
#' @export
createTemporalSequenceCovariateSettings <- function(useDemographicsGender = FALSE,
                                                    useDemographicsAge = FALSE,
                                                    useDemographicsAgeGroup = FALSE,
                                                    useDemographicsRace = FALSE,
                                                    useDemographicsEthnicity = FALSE,
                                                    useDemographicsIndexYear = FALSE,
                                                    useDemographicsIndexMonth = FALSE,
                                                    useConditionOccurrence = FALSE,
                                                    useConditionOccurrencePrimaryInpatient = FALSE,
                                                    useConditionEraStart = FALSE,
                                                    useConditionEraGroupStart = FALSE,
                                                    useDrugExposure = FALSE,
                                                    useDrugEraStart = FALSE,
                                                    useDrugEraGroupStart = FALSE,
                                                    useProcedureOccurrence = FALSE,
                                                    useDeviceExposure = FALSE,
                                                    useMeasurement = FALSE,
                                                    useMeasurementValue = FALSE,
                                                    useObservation = FALSE,
                                                    timePart = "month",
                                                    timeInterval = 1,
                                                    sequenceEndDay = -1,
                                                    sequenceStartDay = -730,
                                                    includedCovariateConceptIds = c(),
                                                    addDescendantsToInclude = FALSE,
                                                    excludedCovariateConceptIds = c(),
                                                    addDescendantsToExclude = FALSE,
                                                    includedCovariateIds = c()) {
  covariateSettings <- list(
    temporal = FALSE,
    temporalSequence = TRUE
  )
  formalNames <- names(formals(createTemporalSequenceCovariateSettings))
  anyUseTrue <- FALSE
  for (name in formalNames) {
    value <- get(name)
    if (is.null(value)) {
      value <- vector()
    }
    if (grepl("use.*", name)) {
      if (value) {
        covariateSettings[[sub("use", "", name)]] <- value
        anyUseTrue <- TRUE
      }
    } else {
      covariateSettings[[name]] <- value
    }
  }
  if (!anyUseTrue) {
    stop("No covariate analysis selected. Must select at least one")
  }
  attr(covariateSettings, "fun") <- "getDbDefaultCovariateData"
  class(covariateSettings) <- "covariateSettings"
  return(covariateSettings)
}
