% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetCovariatesFromCohortAttributes.R
\name{createCohortAttrCovariateSettings}
\alias{createCohortAttrCovariateSettings}
\title{Create cohort attribute covariate settings}
\usage{
createCohortAttrCovariateSettings(
  analysisId = -1,
  attrDatabaseSchema,
  attrDefinitionTable = "attribute_definition",
  cohortAttrTable = "cohort_attribute",
  includeAttrIds = c(),
  isBinary = FALSE,
  missingMeansZero = FALSE
)
}
\arguments{
\item{analysisId}{A unique identifier for this analysis.}

\item{attrDatabaseSchema}{The database schema where the attribute definition and cohort attribute
table can be found.}

\item{attrDefinitionTable}{The name of the attribute definition table.}

\item{cohortAttrTable}{The name of the cohort attribute table.}

\item{includeAttrIds}{(optional) A list of attribute definition IDs to restrict to.}

\item{isBinary}{Needed for aggregation: Are these binary variables? Binary
variables should only have the values 0 or 1.}

\item{missingMeansZero}{Needed for aggregation: For continuous values, should missing
values be interpreted as 0?}
}
\value{
An object of type \code{covariateSettings}, to be used in other functions.
}
\description{
Create cohort attribute covariate settings
}
\details{
Creates an object specifying where the cohort attributes can be found to construct covariates. The
attributes should be defined in a table with the same structure as the attribute_definition table
in the Common Data Model. It should at least have these columns: \describe{
\item{attribute_definition_id}{A unique identifier of type integer.} \item{attribute_name}{A short
description of the attribute.} } The cohort attributes themselves should be stored in a table with
the same format as the cohort_attribute table in the Common Data Model. It should at least have
these columns: \describe{ \item{cohort_definition_id}{A key to link to the cohort table.}
\item{subject_id}{A key to link to the cohort table.} \item{cohort_start_date}{A key to link to the
cohort table.} \item{attribute_definition_id}{An foreign key linking to the attribute definition
table.} \item{value_as_number}{A real number.} }
}
\examples{
\donttest{
covariateSettings <- createCohortAttrCovariateSettings(
  analysisId = 1,
  attrDatabaseSchema = "main",
  attrDefinitionTable = "attribute_definition",
  cohortAttrTable = "cohort_attribute",
  includeAttrIds = c(1),
  isBinary = FALSE,
  missingMeansZero = FALSE
)
}

}
